/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.Collections;
import java.util.List;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.spi.RelationshipPolicy;

public class IdentityConfiguration {
    private final String name;
    private final List<? extends IdentityStoreConfiguration> storeConfiguration;
    private final RelationshipPolicy relationshipPolicy;

    IdentityConfiguration(String name, List<? extends IdentityStoreConfiguration> identityStores, RelationshipPolicy relationshipPolicy) {
        if (name == null) {
            throw new SecurityConfigurationException("You must specify a name for the IdentityConfiguration.");
        }
        this.name = name;
        this.storeConfiguration = Collections.unmodifiableList(identityStores);
        this.relationshipPolicy = relationshipPolicy;
    }

    public RelationshipPolicy getRelationshipPolicy() {
        return this.relationshipPolicy;
    }

    public String getName() {
        return this.name;
    }

    public List<? extends IdentityStoreConfiguration> getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public boolean supportsPartition() {
        for (IdentityStoreConfiguration identityStoreConfiguration : this.getStoreConfiguration()) {
            if (!identityStoreConfiguration.supportsPartition()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        IdentityConfiguration other = (IdentityConfiguration)obj;
        return this.getName() != null && other.getName() != null && this.getName().equals(other.getName());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

