/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.federation;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceName;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.service.FederationService;
import org.picketlink.as.subsystem.service.IdentityProviderService;
import org.picketlink.as.subsystem.service.ServiceProviderService;

public class FederationRemoveHandler
extends AbstractRemoveStepHandler {
    public static final FederationRemoveHandler INSTANCE = new FederationRemoveHandler();

    private FederationRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        this.removeIdentityProviderService(context, model);
        this.removeServiceProviderService(context, model);
        this.removeFederationService(context, operation);
        context.restartRequired();
    }

    private void removeFederationService(OperationContext context, ModelNode operation) {
        String suffix = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceName name = FederationService.createServiceName(suffix);
        context.removeService(name);
    }

    private void removeServiceProviderService(OperationContext context, ModelNode model) {
        if (model.get(ModelElement.SERVICE_PROVIDER.getName()).isDefined()) {
            for (Property serviceProviders : this.getServiceProviders(model)) {
                ServiceName name = ServiceProviderService.createServiceName(serviceProviders.getName());
                context.removeService(name);
            }
        }
    }

    private void removeIdentityProviderService(OperationContext context, ModelNode model) {
        if (this.hasIdentityProvider(model)) {
            String idpAlias = this.getIdentityProvider(model).getName();
            ServiceName name = IdentityProviderService.createServiceName(idpAlias);
            context.removeService(name);
        }
    }

    private List<Property> getServiceProviders(ModelNode model) {
        return model.get(ModelElement.SERVICE_PROVIDER.getName()).asPropertyList();
    }

    private Property getIdentityProvider(ModelNode model) {
        return (Property)model.get(ModelElement.IDENTITY_PROVIDER.getName()).asPropertyList().get(0);
    }

    private boolean hasIdentityProvider(ModelNode model) {
        return model.get(ModelElement.IDENTITY_PROVIDER.getName()).isDefined() && !model.get(ModelElement.IDENTITY_PROVIDER.getName()).asPropertyList().isEmpty();
    }
}

