/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.util;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityActions {
    static String getSystemProperty(final String key, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key, defaultValue);
                }
            });
        }
        return System.getProperty(key, defaultValue);
    }

    static URL loadResource(final Class<?> clazz, final String resourceName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    URL url = null;
                    ClassLoader clazzLoader = clazz.getClassLoader();
                    url = clazzLoader.getResource(resourceName);
                    if (url == null) {
                        clazzLoader = Thread.currentThread().getContextClassLoader();
                        url = clazzLoader.getResource(resourceName);
                    }
                    return url;
                }
            });
        }
        URL url = null;
        ClassLoader clazzLoader = clazz.getClassLoader();
        url = clazzLoader.getResource(resourceName);
        if (url == null) {
            clazzLoader = Thread.currentThread().getContextClassLoader();
            url = clazzLoader.getResource(resourceName);
        }
        return url;
    }
}

