/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.config;

import java.io.InputStream;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.PicketLinkType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.config.PicketLinkConfigParser;
import org.picketlink.identity.federation.core.parsers.config.SAMLConfigParser;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public abstract class AbstractSAMLConfigurationProvider
implements SAMLConfigurationProvider {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String VALIDATING_ALIAS = "ValidatingAlias";
    protected IDPType configParsedIDPType = null;
    protected SPType configParsedSPType = null;
    protected PicketLinkType configParsedPicketLinkType = null;

    @Deprecated
    public void setConfigFile(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        SAMLConfigParser parser = new SAMLConfigParser();
        Object parsedObject = parser.parse(is);
        if (parsedObject instanceof IDPType) {
            this.configParsedIDPType = (IDPType)parsedObject;
        } else {
            this.configParsedSPType = (SPType)parsedObject;
        }
    }

    public void setConsolidatedConfigFile(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("InputStream");
        }
        PicketLinkConfigParser parser = new PicketLinkConfigParser();
        PicketLinkType parsedObject = (PicketLinkType)parser.parse(is);
        if (parsedObject.getIdpOrSP() instanceof IDPType) {
            this.configParsedIDPType = (IDPType)parsedObject.getIdpOrSP();
        } else {
            this.configParsedSPType = (SPType)parsedObject.getIdpOrSP();
        }
        this.configParsedPicketLinkType = parsedObject;
    }

    public abstract IDPType getIDPConfiguration() throws ProcessingException;

    public abstract SPType getSPConfiguration() throws ProcessingException;

    public PicketLinkType getPicketLinkConfiguration() throws ProcessingException {
        return this.configParsedPicketLinkType;
    }
}

