/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.model.handlers;

import java.util.ArrayList;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.as.subsystem.service.AbstractEntityProviderService;
import org.picketlink.as.subsystem.service.IdentityProviderService;
import org.picketlink.as.subsystem.service.ServiceProviderService;
import org.picketlink.identity.federation.core.handler.config.Handler;
import org.picketlink.identity.federation.core.handler.config.Handlers;

public class HandlerRemoveHandler
extends AbstractRemoveStepHandler {
    public static final HandlerRemoveHandler INSTANCE = new HandlerRemoveHandler();

    private HandlerRemoveHandler() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String providerAlias = ((Property)operation.get("address").asPropertyList().get(2)).getValue().asString();
        String className = operation.get(ModelElement.COMMON_HANDLER_CLASS.getName()).asString();
        AbstractEntityProviderService providerService = this.getParentProviderService(context, providerAlias);
        Handlers handlerChain = providerService.getPicketLinkType().getHandlers();
        for (Handler handler : new ArrayList(handlerChain.getHandler())) {
            if (!handler.getClazz().equals(className)) continue;
            handlerChain.remove(handler);
        }
    }

    private AbstractEntityProviderService getParentProviderService(OperationContext context, String providerAlias) {
        AbstractEntityProviderService providerService = IdentityProviderService.getService(context.getServiceRegistry(true), providerAlias);
        if (providerService == null) {
            providerService = ServiceProviderService.getService(context.getServiceRegistry(true), providerAlias);
        }
        return providerService;
    }
}

