/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.picketlink.as.subsystem.PicketLinkLogger;
import org.picketlink.as.subsystem.service.PicketLinkService;

public abstract class AbstractPicketLinkDeploymentProcessor<T extends PicketLinkService<T>>
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.INSTALL;
    public static final int PRIORITY = 1;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentUnitName = deploymentUnit.getName();
        T service = this.getService(phaseContext.getServiceRegistry(), deploymentUnitName);
        if (service != null) {
            PicketLinkLogger.ROOT_LOGGER.configuringDeployment(service.getClass().getSimpleName(), deploymentUnitName);
            service.configure(deploymentUnit);
        }
    }

    private T getService(ServiceRegistry serviceRegistry, String deploymentUnitName) {
        ServiceController container = serviceRegistry.getService(this.createServiceName(deploymentUnitName));
        if (container != null) {
            return (T)((PicketLinkService)container.getValue());
        }
        return null;
    }

    protected abstract ServiceName createServiceName(String var1);

    public void undeploy(DeploymentUnit context) {
    }
}

