/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.PublicKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.web.handlers.saml2.SAML2SignatureGenerationHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SAML2EncryptionHandler
extends SAML2SignatureGenerationHandler {
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (this.supportsRequest(request) && this.isEncryptionEnabled()) {
            Document samlResponseDocument = response.getResultingDocument();
            if (samlResponseDocument == null) {
                this.throwResponseDocumentOrAssertionNotFound();
            }
            String samlNSPrefix = this.getSAMLNSPrefix(samlResponseDocument);
            try {
                QName encryptedAssertionElementQName = new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ENCRYPTED_ASSERTION.get(), samlNSPrefix);
                byte[] secret = WSTrustUtil.createRandomSecret(16);
                SecretKeySpec secretKey = new SecretKeySpec(secret, this.getAlgorithm());
                XMLEncryptionUtil.encryptElement(new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get(), samlNSPrefix), samlResponseDocument, this.getSenderPublicKey(request), secretKey, this.getKeySize(), encryptedAssertionElementQName, true);
            }
            catch (Exception e) {
                throw logger.processingError(e);
            }
        }
        super.handleRequestType(request, response);
    }

    private String getSAMLNSPrefix(Document samlResponseDocument) {
        Node assertionElement = samlResponseDocument.getDocumentElement().getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ASSERTION.get()).item(0);
        if (assertionElement == null) {
            this.throwResponseDocumentOrAssertionNotFound();
        }
        return assertionElement.getPrefix();
    }

    private boolean isEncryptionEnabled() {
        return this.getType() == SAML2Handler.HANDLER_TYPE.IDP && this.getConfiguration().isEncrypt();
    }

    private boolean supportsRequest(SAML2HandlerRequest request) {
        return this.getType() == SAML2Handler.HANDLER_TYPE.IDP && request.getSAML2Object() instanceof AuthnRequestType;
    }

    private IDPType getConfiguration() {
        IDPType configuration = (IDPType)this.handlerChainConfig.getParameter("CONFIGURATION");
        if (configuration == null) {
            throw logger.nullArgumentError("IDP Configuration");
        }
        return configuration;
    }

    private int getKeySize() {
        String keySize = (String)this.handlerConfig.getParameter("SAML_ENC_KEY_SIZE");
        if (keySize == null) {
            keySize = String.valueOf(128);
        }
        return Integer.valueOf(keySize);
    }

    private String getAlgorithm() {
        String algorithm = (String)this.handlerConfig.getParameter("SAML_ENC_ALGORITHM");
        if (algorithm == null) {
            algorithm = "AES";
        }
        return algorithm;
    }

    private PublicKey getSenderPublicKey(SAML2HandlerRequest request) {
        PublicKey publicKey = (PublicKey)request.getOptions().get("SENDER_PUBLIC_KEY");
        if (publicKey == null) {
            throw logger.nullArgumentError("Sender Public Key");
        }
        return publicKey;
    }

    private void throwResponseDocumentOrAssertionNotFound() {
        throw new IllegalStateException("No response document/assertions found. Check if this handler is after the SAML2AuthenticationHandler.");
    }
}

