/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.Authenticator;
import org.picketlink.authentication.LockedAccountException;
import org.picketlink.authentication.UnexpectedCredentialException;
import org.picketlink.authentication.UserAlreadyLoggedInException;
import org.picketlink.authentication.event.AlreadyLoggedInEvent;
import org.picketlink.authentication.event.LockedAccountEvent;
import org.picketlink.authentication.event.LoggedInEvent;
import org.picketlink.authentication.event.LoginFailedEvent;
import org.picketlink.authentication.event.PostAuthenticateEvent;
import org.picketlink.authentication.event.PostLoggedOutEvent;
import org.picketlink.authentication.event.PreAuthenticateEvent;
import org.picketlink.authentication.event.PreLoggedOutEvent;
import org.picketlink.authentication.internal.IdmAuthenticator;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.idm.model.Account;
import org.picketlink.permission.internal.PermissionMapper;

@SessionScoped
@Named(value="identity")
public class DefaultIdentity
implements Identity {
    private static final long serialVersionUID = 3696702275353144429L;
    @Inject
    private BeanManager beanManager;
    @Inject
    private DefaultLoginCredentials loginCredential;
    @Inject
    @PicketLink
    private Instance<Authenticator> authenticatorInstance;
    @Inject
    private Instance<IdmAuthenticator> idmAuthenticatorInstance;
    @Inject
    private PermissionMapper permissionMapper;
    private boolean authenticating;
    private Account account;

    public boolean isLoggedIn() {
        return this.account != null;
    }

    public Account getAccount() {
        return this.account;
    }

    public Identity.AuthenticationResult login() {
        try {
            if (this.isLoggedIn()) {
                throw new UserAlreadyLoggedInException("active agent: " + this.account.toString());
            }
            Account validatedAccount = this.authenticate();
            if (validatedAccount != null) {
                if (!validatedAccount.isEnabled()) {
                    throw new LockedAccountException("Account [" + validatedAccount + "] is disabled.");
                }
                this.handleSuccessfulLoginAttempt(validatedAccount);
                return Identity.AuthenticationResult.SUCCESS;
            }
            this.handleUnsuccesfulLoginAttempt(null);
            return Identity.AuthenticationResult.FAILED;
        }
        catch (Throwable e) {
            this.handleUnsuccesfulLoginAttempt(e);
            if (AuthenticationException.class.isInstance(e)) {
                throw (AuthenticationException)e;
            }
            throw new AuthenticationException("Login failed with a unexpected error.", e);
        }
    }

    protected void handleSuccessfulLoginAttempt(Account validatedAccount) {
        this.account = validatedAccount;
        this.beanManager.fireEvent((Object)new LoggedInEvent(), new Annotation[0]);
    }

    protected void handleUnsuccesfulLoginAttempt(Throwable e) {
        if (e != null && !UnexpectedCredentialException.class.isInstance(e)) {
            if (UserAlreadyLoggedInException.class.isInstance(e)) {
                this.beanManager.fireEvent((Object)new AlreadyLoggedInEvent(), new Annotation[0]);
            } else if (LockedAccountException.class.isInstance(e)) {
                this.beanManager.fireEvent((Object)new LockedAccountEvent(), new Annotation[0]);
            }
        }
        this.beanManager.fireEvent((Object)new LoginFailedEvent(e), new Annotation[0]);
    }

    protected Account authenticate() throws AuthenticationException {
        Account validatedAccount = null;
        if (this.authenticating) {
            this.authenticating = false;
            throw new IllegalStateException("Authentication already in progress.");
        }
        try {
            Authenticator authenticator;
            this.authenticating = true;
            this.beanManager.fireEvent((Object)new PreAuthenticateEvent(), new Annotation[0]);
            Authenticator authenticator2 = authenticator = this.authenticatorInstance.isUnsatisfied() ? (Authenticator)this.idmAuthenticatorInstance.get() : (Authenticator)this.authenticatorInstance.get();
            if (authenticator == null) {
                throw new AuthenticationException("No Authenticator has been configured.");
            }
            authenticator.authenticate();
            if (authenticator.getStatus() == null) {
                throw new AuthenticationException("Authenticator must return a valid authentication status");
            }
            if (authenticator.getStatus() == Authenticator.AuthenticationStatus.SUCCESS) {
                validatedAccount = authenticator.getAccount();
                this.postAuthenticate(authenticator);
            }
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new AuthenticationException("Authentication failed.", ex);
        }
        finally {
            this.authenticating = false;
        }
        return validatedAccount;
    }

    protected void postAuthenticate(Authenticator authenticator) {
        authenticator.postAuthenticate();
        if (!authenticator.getStatus().equals((Object)Authenticator.AuthenticationStatus.SUCCESS)) {
            return;
        }
        this.beanManager.fireEvent((Object)new PostAuthenticateEvent(), new Annotation[0]);
    }

    public void logout() {
        this.logout(true);
    }

    protected void logout(boolean invalidateLoginCredential) {
        if (this.isLoggedIn()) {
            this.beanManager.fireEvent((Object)new PreLoggedOutEvent(this.account), new Annotation[0]);
            PostLoggedOutEvent postLoggedOutEvent = new PostLoggedOutEvent(this.account);
            this.unAuthenticate(invalidateLoginCredential);
            this.beanManager.fireEvent((Object)postLoggedOutEvent, new Annotation[0]);
        }
    }

    private void unAuthenticate(boolean invalidateLoginCredential) {
        this.account = null;
        if (invalidateLoginCredential) {
            this.loginCredential.invalidate();
        }
    }

    public boolean hasPermission(Object resource, String operation) {
        return this.permissionMapper.resolvePermission(resource, operation);
    }

    public boolean hasPermission(Class<?> resourceClass, Serializable identifier, String operation) {
        return this.permissionMapper.resolvePermission(resourceClass, identifier, operation);
    }
}

