/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.ws.handler.MessageContext;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.extensions.CredentialIdentity;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.trust.jbossws.handler.AbstractPicketLinkTrustHandler;
import org.picketlink.trust.jbossws.handler.SecurityActions;

public abstract class AbstractWSAuthenticationHandler
extends AbstractPicketLinkTrustHandler {
    protected boolean handleInbound(MessageContext msgContext) {
        logger.trace("Handling Inbound Message");
        this.trace(msgContext);
        AuthenticationManager authenticationManager = null;
        try {
            authenticationManager = this.getAuthenticationManager(msgContext);
        }
        catch (ConfigurationException e) {
            logger.authenticationManagerError(e);
            throw new RuntimeException(e);
        }
        Principal principal = null;
        Object credential = null;
        for (CredentialIdentity identity : SecurityContextAssociation.getSecurityContext().getSubjectInfo().getIdentities()) {
            principal = identity.asPrincipal();
            credential = identity.getCredential();
        }
        Subject subject = new Subject();
        if (!authenticationManager.isValid(principal, credential, subject)) {
            String msg = "PL00102: Processing Exception:Authentication failed, principal=" + principal;
            logger.error(msg);
            SecurityException e = new SecurityException(msg);
            throw new RuntimeException(e);
        }
        logger.trace("Successfully Authenticated:Principal = " + principal + "  ::subject = " + subject);
        SecurityContext sc = SecurityActions.createSecurityContext(principal, credential, subject);
        SecurityActions.setSecurityContext(sc);
        return true;
    }

    protected AuthenticationManager getAuthenticationManager(MessageContext msgContext) throws ConfigurationException {
        String securityDomainName = this.getSecurityDomainName(msgContext);
        return (AuthenticationManager)this.lookupJNDI("java:jboss/jaas/" + securityDomainName);
    }
}

