/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.w3c.dom.Node;

public class PicketLinkDispatch
implements Dispatch<Source> {
    private Dispatch parent;
    private String endpoint;
    private boolean useWSSE = false;
    private SSLSocketFactory sslSocketFactory;

    public PicketLinkDispatch(Dispatch parent, String endpoint) {
        this.parent = parent;
        this.endpoint = endpoint;
    }

    public void setUseWSSE(boolean val) {
        this.useWSSE = val;
    }

    public void setSSLSocketFactory(SSLSocketFactory ssl) {
        this.sslSocketFactory = ssl;
    }

    public Map<String, Object> getRequestContext() {
        return this.parent.getRequestContext();
    }

    public Map<String, Object> getResponseContext() {
        return this.parent.getResponseContext();
    }

    public Binding getBinding() {
        return this.parent.getBinding();
    }

    public EndpointReference getEndpointReference() {
        return this.parent.getEndpointReference();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return (T)this.parent.getEndpointReference(clazz);
    }

    public Source invoke(Source requestMessage) {
        PLMessageContext msgContext = new PLMessageContext();
        msgContext.put("javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
        String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
        }
        catch (PolicyContextException e1) {
            throw new RuntimeException(e1);
        }
        msgContext.put("javax.xml.ws.servlet.request", (Object)request);
        SOAPMessage soapMessage = null;
        try {
            soapMessage = SOAPUtil.create();
        }
        catch (SOAPException e2) {
            throw new RuntimeException(e2);
        }
        String userName = (String)this.parent.getRequestContext().get("javax.xml.ws.security.auth.username");
        String passwd = (String)this.parent.getRequestContext().get("javax.xml.ws.security.auth.password");
        if (StringUtil.isNotNull((String)userName)) {
            try {
                if (this.useWSSE) {
                    SOAPElement security = this.create(userName, passwd);
                    soapMessage.getSOAPHeader().appendChild((Node)security);
                } else {
                    String authorization = Base64.encodeBytes((byte[])(userName + ":" + passwd).getBytes());
                    soapMessage.getMimeHeaders().addHeader("Authorization", "Basic " + authorization);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            SOAPUtil.addData((Source)requestMessage, (SOAPMessage)soapMessage);
        }
        catch (SOAPException e1) {
            throw new RuntimeException(e1);
        }
        msgContext.setMessage(soapMessage);
        List handlers = this.getBinding().getHandlerChain();
        for (Handler handler : handlers) {
            boolean result = handler.handleMessage((MessageContext)msgContext);
            if (result) continue;
            throw new WebServiceException("PL00102: Processing Exception:Handler " + handler.getClass() + " returned false");
        }
        if (this.sslSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sslSocketFactory);
        }
        SOAPMessage response = null;
        try {
            SOAPConnectionFactory connectFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = connectFactory.createConnection();
            URL url = new URL(this.endpoint);
            response = connection.call(soapMessage, (Object)url);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return new DOMSource(SOAPUtil.getSOAPData((SOAPMessage)response));
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public Response<Source> invokeAsync(Source msg) {
        return this.parent.invokeAsync((Object)msg);
    }

    public Future<?> invokeAsync(Source msg, AsyncHandler<Source> handler) {
        return this.parent.invokeAsync((Object)msg, handler);
    }

    public void invokeOneWay(Source msg) {
        this.parent.invokeOneWay((Object)msg);
    }

    private SOAPElement create(String userName, String pass) throws SOAPException {
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPElement security = factory.createElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        security.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        SOAPElement userNameToken = factory.createElement("UsernameToken", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        userNameToken.addAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu"), IDGenerator.create((String)"token-"));
        SOAPElement un = factory.createElement("Username", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        un.addTextNode(userName);
        userNameToken.addChildElement(un);
        SOAPElement passElement = factory.createElement("Password", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        passElement.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0#PasswordText");
        passElement.addTextNode(pass);
        userNameToken.addChildElement(passElement);
        security.addChildElement(userNameToken);
        return security;
    }

    public static class PLMessageContext
    implements MessageContext,
    SOAPMessageContext {
        private Map<String, Object> map = new HashMap<String, Object>();
        private Map<String, MessageContext.Scope> scopeMap = new HashMap<String, MessageContext.Scope>();
        private Map<String, Object> properties = new HashMap<String, Object>();
        private SOAPMessage message;

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public Object put(String key, Object value) {
            return this.map.put(key, value);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        public void putAll(Map<? extends String, ? extends Object> m) {
            this.map.putAll(m);
        }

        public void clear() {
            this.map.clear();
        }

        public Set<String> keySet() {
            return this.map.keySet();
        }

        public Collection<Object> values() {
            return this.map.values();
        }

        public Set<Map.Entry<String, Object>> entrySet() {
            return this.map.entrySet();
        }

        public void setScope(String name, MessageContext.Scope scope) {
            this.scopeMap.put(name, scope);
        }

        public MessageContext.Scope getScope(String name) {
            return this.scopeMap.get(name);
        }

        public boolean containsProperty(String name) {
            return this.properties.containsKey(name);
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public Iterator getPropertyNames() {
            return this.properties.keySet().iterator();
        }

        public void removeProperty(String name) {
            this.properties.remove(name);
        }

        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public SOAPMessage getMessage() {
            return this.message;
        }

        public void setMessage(SOAPMessage message) {
            this.message = message;
        }

        public Object[] getHeaders(QName header, JAXBContext context, boolean allRoles) {
            throw new RuntimeException();
        }

        public Set<String> getRoles() {
            throw new RuntimeException();
        }
    }
}

