/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.jaas;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.util.Base64;
import org.picketlink.identity.federation.core.parsers.saml.SAMLAssertionParser;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLBearerTokenLoginModule
extends AbstractServerLoginModule {
    public static final String AUTHORIZATION = "Authorization";
    public static final String BASIC = "Basic";
    public static final String SAML_BEARER_TOKEN = "SAML-BEARER-TOKEN:";
    private Set<String> allowedIssuers = new HashSet<String>();
    private Principal identity;
    private Set<String> roles = new HashSet<String>();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        String val = (String)options.get("allowedIssuers");
        if (val != null) {
            String[] split;
            for (String issuer : split = val.split(",")) {
                if (issuer == null || issuer.trim().length() <= 0) continue;
                this.allowedIssuers.add(issuer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        InputStream is = null;
        try {
            String b64Data;
            byte[] dataBytes;
            String data;
            HttpServletRequest request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
            String authorization = request.getHeader(AUTHORIZATION);
            if (authorization != null && authorization.startsWith(BASIC) && (data = new String(dataBytes = Base64.decode((String)(b64Data = authorization.substring(6))), "UTF-8")).startsWith(SAML_BEARER_TOKEN)) {
                String assertionData = data.substring(18);
                SAMLAssertionParser parser = new SAMLAssertionParser();
                is = new ByteArrayInputStream(assertionData.getBytes("UTF-8"));
                XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(is);
                Object parsed = parser.parse(xmlEventReader);
                AssertionType assertion = (AssertionType)parsed;
                this.validateAssertion(assertion, request);
                this.consumeAssertion(assertion);
                this.loginOk = true;
                boolean bl = true;
                return bl;
            }
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loginOk = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return super.login();
    }

    private void validateAssertion(AssertionType assertion, HttpServletRequest request) throws LoginException {
        block6: {
            String issuer = assertion.getIssuer().getValue();
            if (!this.allowedIssuers.contains(issuer)) {
                throw new LoginException("Dis-allowed SAML Assertion Issuer: " + issuer + " Allowed: " + this.allowedIssuers);
            }
            String currentAudience = request.getContextPath();
            Set<String> audienceRestrictions = this.getAudienceRestrictions(assertion);
            if (!audienceRestrictions.contains(currentAudience)) {
                throw new LoginException("SAML Assertion Audience Restrictions not valid for this context (" + currentAudience + ")");
            }
            try {
                ConditionsType conditionsType = assertion.getConditions();
                if (conditionsType != null) {
                    XMLGregorianCalendar notOnOrAfter;
                    XMLGregorianCalendar notBefore;
                    XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
                    if (!XMLTimeUtil.isValid((XMLGregorianCalendar)now, (XMLGregorianCalendar)(notBefore = conditionsType.getNotBefore()), (XMLGregorianCalendar)(notOnOrAfter = conditionsType.getNotOnOrAfter()))) {
                        String msg = "SAML Assertion has expired: Now=" + now.toXMLFormat() + " ::notBefore=" + notBefore.toXMLFormat() + " ::notOnOrAfter=" + notOnOrAfter;
                        throw new LoginException(msg);
                    }
                    break block6;
                }
                throw new LoginException("SAML Assertion not valid (no Conditions supplied).");
            }
            catch (ConfigurationException e) {
                throw new LoginException(e.getMessage());
            }
        }
    }

    private Set<String> getAudienceRestrictions(AssertionType assertion) {
        HashSet<String> rval = new HashSet<String>();
        if (assertion == null || assertion.getConditions() == null || assertion.getConditions().getConditions() == null) {
            return rval;
        }
        List conditions = assertion.getConditions().getConditions();
        for (ConditionAbstractType conditionAbstractType : conditions) {
            if (!(conditionAbstractType instanceof AudienceRestrictionType)) continue;
            AudienceRestrictionType art = (AudienceRestrictionType)conditionAbstractType;
            List audiences = art.getAudience();
            for (URI uri : audiences) {
                rval.add(uri.toString());
            }
        }
        return rval;
    }

    private void consumeAssertion(AssertionType assertion) throws Exception {
        SubjectType samlSubjectType = assertion.getSubject();
        String samlSubject = ((NameIDType)samlSubjectType.getSubType().getBaseID()).getValue();
        this.identity = this.createIdentity(samlSubject);
        Set statements = assertion.getStatements();
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attrStatement = (AttributeStatementType)statement;
            List attributes = attrStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType astChoiceType : attributes) {
                if (astChoiceType.getAttribute() == null || !astChoiceType.getAttribute().getName().equals("Role")) continue;
                List values = astChoiceType.getAttribute().getAttributeValue();
                for (Object roleValue : values) {
                    if (roleValue == null) continue;
                    this.roles.add(roleValue.toString());
                }
            }
        }
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] groups = new Group[]{new SimpleGroup("Roles")};
        try {
            for (String role : this.roles) {
                groups[0].addMember(this.createIdentity(role));
            }
        }
        catch (Exception e) {
            throw new LoginException("Failed to create group principal: " + e.getMessage());
        }
        return groups;
    }
}

