/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jwt;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.picketlink.json.util.JsonUtil;

public class JWT {
    private JsonObject headers;
    private final JsonObject claims;

    protected JWT(JsonObject headers, JsonObject claims) {
        this.headers = headers;
        this.claims = claims;
    }

    public String encode() {
        return this.format(JsonUtil.b64Encode(this.getPlainHeader()), JsonUtil.b64Encode(this.getPlainClaims())).toString();
    }

    public String geType() {
        return this.getHeader("typ");
    }

    public String getContentType() {
        return this.getHeader("cty");
    }

    public String getId() {
        return this.getClaim("jti");
    }

    public String getIssuer() {
        return this.getClaim("iss");
    }

    public List<String> getAudience() {
        return this.getClaimValues("aud");
    }

    public String getSubject() {
        return this.getClaim("sub");
    }

    public Integer getIssuedAt() {
        return Integer.valueOf(this.getClaim("iat").toString());
    }

    public Integer getExpiration() {
        return Integer.valueOf(this.getClaim("exp").toString());
    }

    public Integer getNotBefore() {
        return Integer.valueOf(this.getClaim("nbf").toString());
    }

    public String toString() {
        return this.format(this.getPlainHeader(), this.getPlainClaims()).toString();
    }

    public JsonObject getClaims() {
        return this.claims;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public String getClaim(String name) {
        return this.getValue(name, this.claims);
    }

    public List<String> getClaimValues(String name) {
        return this.getValues(name, this.claims);
    }

    public String getHeader(String name) {
        return this.getValue(name, this.headers);
    }

    public List<String> getHeaderValues(String name) {
        return this.getValues(name, this.headers);
    }

    private StringBuilder format(String header, String claimsSet) {
        return new StringBuilder().append(header).append(".").append(claimsSet);
    }

    private String getPlainClaims() {
        StringWriter claimsWriter = new StringWriter();
        Json.createWriter((Writer)claimsWriter).writeObject(this.claims);
        return claimsWriter.getBuffer().toString();
    }

    private String getPlainHeader() {
        StringWriter headerWriter = new StringWriter();
        Json.createWriter((Writer)headerWriter).writeObject(this.headers);
        return headerWriter.getBuffer().toString();
    }

    private List<String> getValues(String name, JsonObject jsonObject) {
        JsonValue headerValue = (JsonValue)jsonObject.get((Object)name);
        ArrayList<String> values = new ArrayList<String>();
        if (headerValue != null) {
            if (JsonArray.class.isInstance(headerValue)) {
                JsonArray array = (JsonArray)headerValue;
                for (JsonValue aud : array.getValuesAs(JsonValue.class)) {
                    values.add(this.getValue(aud).toString());
                }
            } else {
                values.add(this.getValue(name, jsonObject).toString());
            }
        }
        return values;
    }

    private <R> R getValue(JsonValue value) {
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return this.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return (R)((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return (R)((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return (R)Boolean.valueOf(value.toString());
            }
        }
        return null;
    }

    private String getValue(String name, JsonObject jsonObject) {
        JsonValue value = (JsonValue)jsonObject.get((Object)name);
        if (JsonValue.ValueType.ARRAY.equals((Object)value.getValueType())) {
            JsonArray array = (JsonArray)value;
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonValue jsonValue = (JsonValue)i$.next();
                return (String)this.getValue(jsonValue);
            }
        } else {
            if (JsonValue.ValueType.STRING.equals((Object)value.getValueType())) {
                return ((JsonString)value).getString();
            }
            if (JsonValue.ValueType.NUMBER.equals((Object)value.getValueType())) {
                return ((JsonNumber)value).bigDecimalValue().toPlainString();
            }
            if (JsonValue.ValueType.TRUE.equals((Object)value.getValueType()) || JsonValue.ValueType.FALSE.equals((Object)value.getValueType())) {
                return value.toString();
            }
        }
        return null;
    }
}

