/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jwt;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import org.picketlink.json.util.Base64Util;
import org.picketlink.json.util.JsonUtil;

public class JWT {
    private JsonObject headers;
    private final JsonObject claims;

    protected JWT(JsonObject headers, JsonObject claims) {
        this.headers = headers;
        this.claims = claims;
    }

    public String encode() {
        return this.format(Base64Util.b64Encode(this.getPlainHeader()), Base64Util.b64Encode(this.getPlainClaims())).toString();
    }

    public String geType() {
        return this.getHeader("typ");
    }

    public String getContentType() {
        return this.getHeader("cty");
    }

    public String getId() {
        return this.getClaim("jti");
    }

    public String getIssuer() {
        return this.getClaim("iss");
    }

    public List<String> getAudience() {
        return this.getClaimValues("aud");
    }

    public String getSubject() {
        return this.getClaim("sub");
    }

    public Integer getIssuedAt() {
        String claim = this.getClaim("iat");
        if (claim != null) {
            return Integer.valueOf(claim.toString());
        }
        return null;
    }

    public Date getIssuedAtDate() {
        Integer issuedAt = this.getIssuedAt();
        if (issuedAt != null) {
            return new Date((long)issuedAt.intValue() * 1000L);
        }
        return null;
    }

    public Integer getExpiration() {
        String claim = this.getClaim("exp");
        if (claim != null) {
            return Integer.valueOf(claim.toString());
        }
        return null;
    }

    public Date getExpirationDate() {
        Integer expiration = this.getExpiration();
        if (expiration != null) {
            return new Date((long)expiration.intValue() * 1000L);
        }
        return null;
    }

    public Integer getNotBefore() {
        String claim = this.getClaim("nbf");
        if (claim != null) {
            return Integer.valueOf(claim.toString());
        }
        return null;
    }

    public Date getNotBeforeDate() {
        Integer notBefore = this.getNotBefore();
        if (notBefore != null) {
            return new Date((long)notBefore.intValue() * 1000L);
        }
        return null;
    }

    public String toString() {
        return this.format(this.getPlainHeader(), this.getPlainClaims()).toString();
    }

    public JsonObject getClaims() {
        return this.claims;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public String getClaim(String name) {
        return JsonUtil.getValue(name, this.claims);
    }

    public List<String> getClaimValues(String name) {
        return JsonUtil.getValues(name, this.claims);
    }

    public String getHeader(String name) {
        return JsonUtil.getValue(name, this.headers);
    }

    public List<String> getHeaderValues(String name) {
        return JsonUtil.getValues(name, this.headers);
    }

    private StringBuilder format(String header, String claimsSet) {
        return new StringBuilder().append(header).append(".").append(claimsSet);
    }

    private String getPlainClaims() {
        StringWriter claimsWriter = new StringWriter();
        Json.createWriter((Writer)claimsWriter).writeObject(this.claims);
        return claimsWriter.getBuffer().toString();
    }

    private String getPlainHeader() {
        StringWriter headerWriter = new StringWriter();
        Json.createWriter((Writer)headerWriter).writeObject(this.headers);
        return headerWriter.getBuffer().toString();
    }
}

