/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.util.Base64;

public class Base64Util {
    public static String b64Encode(String str) {
        try {
            return Base64Util.b64Encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw JsonMessages.MESSAGES.failEncodeToken(e);
        }
    }

    public static String b64Encode(byte[] bytes) {
        String s = Base64.encodeBytes(bytes);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] b64Decode(String s) {
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new RuntimeException("Illegal base64url string!");
            }
        }
        try {
            return Base64.decode(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

