/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import org.picketlink.json.util.Base64Util;
import org.picketlink.json.util.JsonUtil;

public class JWE {
    private JsonObject headers;

    protected JWE(JsonObject headers) {
        this.headers = headers;
    }

    public String encode() {
        return Base64Util.b64Encode(this.getPlainHeaders());
    }

    public String getType() {
        return this.getHeader("typ");
    }

    public String getContentType() {
        return this.getHeader("cty");
    }

    public String getAlgorithm() {
        return this.getHeader("alg");
    }

    public String getEncryptionAlgorithm() {
        return this.getHeader("enc");
    }

    public String getCEKBitLength() {
        return this.getHeader("cek_bitlength");
    }

    public String getKeyIdentifier() {
        return this.getHeader("kid");
    }

    public String getCompressionAlgorithm() {
        return this.getHeader("zip");
    }

    public String getJWKSet() {
        return this.getHeader("jku");
    }

    public String getJWK() {
        return this.getHeader("keys");
    }

    public String getX509Url() {
        return this.getHeader("x5u");
    }

    public List<String> getX509CertificateChain() {
        return this.getHeaderValues("x5c");
    }

    public String getX509SHA1CertificateThumbprint() {
        return this.getHeader("x5t");
    }

    public String getX509SHA256CertificateThumbprint() {
        return this.getHeader("x5t#S256");
    }

    public List<String> getCriticalHeader() {
        return this.getHeaderValues("crit");
    }

    public String toString() {
        return this.getPlainHeaders();
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return JsonUtil.getValue(name, this.headers);
    }

    public List<String> getHeaderValues(String name) {
        return JsonUtil.getValues(name, this.headers);
    }

    public JsonObject getJsonObject() {
        return this.headers;
    }

    private String getPlainHeaders() {
        StringWriter keyParameterWriter = new StringWriter();
        Json.createWriter((Writer)keyParameterWriter).writeObject(this.headers);
        return keyParameterWriter.getBuffer().toString();
    }
}

