/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose;

import javax.json.JsonObject;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.crypto.Algorithm;
import org.picketlink.json.jose.crypto.SignatureProvider;
import org.picketlink.json.jwt.JWT;
import org.picketlink.json.util.Base64Util;

public class JWS
extends JWT {
    private final byte[] key;

    protected JWS(JsonObject headers, JsonObject claims, byte[] key) {
        super(headers, claims);
        this.key = key;
    }

    public String getAlgorithm() {
        if (!this.getHeaders().containsKey((Object)"alg")) {
            throw JsonMessages.MESSAGES.missingHeader("alg");
        }
        return this.getHeaders().getString("alg");
    }

    @Override
    public String encode() {
        String token = super.encode();
        Algorithm algorithm = Algorithm.resolve(this.getAlgorithm().toUpperCase());
        if (!algorithm.isNone()) {
            if (this.key == null) {
                throw JsonMessages.MESSAGES.invalidNullArgument("Secret Key");
            }
            SignatureProvider signatureProvider = algorithm.getSignatureProvider();
            byte[] signature = signatureProvider.sign(token.getBytes(), algorithm, this.key);
            token = token + "." + Base64Util.b64Encode(signature);
        }
        return token;
    }
}

