/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.jose.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AES {
    public static KeyGenerator createKeyGenerator() {
        try {
            return KeyGenerator.getInstance("AES", (Provider)new BouncyCastleProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static SecretKey generateKey(int keyBitLength, SecureRandom random) {
        KeyGenerator aesKeyGenerator = AES.createKeyGenerator();
        aesKeyGenerator.init(keyBitLength, random);
        return aesKeyGenerator.generateKey();
    }

    public static AESEngine createCipher(SecretKey secretKey, boolean forEncryption) {
        AESEngine cipher = new AESEngine();
        KeyParameter cipherParams = new KeyParameter(secretKey.getEncoded());
        cipher.init(forEncryption, (CipherParameters)cipherParams);
        return cipher;
    }

    private AES() {
    }
}

