/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json;

import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.picketlink.json.JsonException;
import org.picketlink.json.jose.crypto.Algorithm;

@MessageBundle(projectCode="PLJSON")
public interface JsonMessages {
    public static final JsonMessages MESSAGES = (JsonMessages)Messages.getBundle(JsonMessages.class);

    @Message(id=1, value="The argument %s cannot be null")
    public JsonException invalidNullArgument(String var1);

    @Message(id=2, value="Could not encode token.")
    public JsonException failEncodeToken(@Cause Throwable var1);

    @Message(id=3, value="The given string does not represent a valid JWT token [%s].")
    public JsonException invalidFormat(String var1);

    @Message(id=4, value="Missing header [%s].")
    public JsonException missingHeader(String var1);

    @Message(id=20, value="No such algorithm [%s].")
    public JsonException cryptoNoSuchAlgorithm(String var1, @Cause Throwable var2);

    @Message(id=21, value="Could not verify signature using algorithm [%s].")
    public JsonException cryptoSignatureValidationFailed(Algorithm var1, @Cause Throwable var2);

    @Message(id=22, value="Could not create signature using algorithm [%s].")
    public JsonException cryptoSignatureFailed(Algorithm var1, @Cause Throwable var2);

    @Message(id=23, value="Error creating token instance from type [%s].")
    public JsonException couldNotCreateToken(Class<?> var1, @Cause Throwable var2);

    @Message(id=24, value="Invalid signature for JSON [%s].")
    public JsonException cryptoInvalidSignature(String var1);

    @Message(id=25, value="Signature not present: [%s].")
    public JsonException cryptoSignatureNotPresent(String var1);

    @Message(id=26, value="Could not parse key: [%s].")
    public JsonException cryptoCouldNotParseKey(String var1, @Cause Throwable var2);

    @Message(id=28, value="Unsupported key type: [%s].")
    public JsonException cryptoUnsupportedKey(String var1);
}

