/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json;

import java.io.Serializable;
import java.util.Arrays;
import org.picketlink.json.JsonException;
import org.picketlink.json.JsonMessages;
import org.picketlink.json.jose.crypto.Algorithm;

public class JsonMessages_$bundle
implements Serializable,
JsonMessages {
    private static final long serialVersionUID = 1L;
    public static final JsonMessages_$bundle INSTANCE = new JsonMessages_$bundle();
    private static final String invalidNullArgument = "PLJSON000001: The argument %s cannot be null";
    private static final String failEncodeToken = "PLJSON000002: Could not encode token.";
    private static final String invalidFormat = "PLJSON000003: The given string does not represent a valid JWT token [%s].";
    private static final String missingHeader = "PLJSON000004: Missing header [%s].";
    private static final String cryptoNoSuchAlgorithm = "PLJSON000020: No such algorithm [%s].";
    private static final String cryptoSignatureValidationFailed = "PLJSON000021: Could not verify signature using algorithm [%s].";
    private static final String cryptoSignatureFailed = "PLJSON000022: Could not create signature using algorithm [%s].";
    private static final String couldNotCreateToken = "PLJSON000023: Error creating token instance from type [%s].";
    private static final String cryptoInvalidSignature = "PLJSON000024: Invalid signature for JSON [%s].";
    private static final String cryptoSignatureNotPresent = "PLJSON000025: Signature not present: [%s].";
    private static final String cryptoCouldNotParseKey = "PLJSON000026: Could not parse key: [%s].";
    private static final String cryptoUnsupportedKey = "PLJSON000028: Unsupported key type: [%s].";

    protected JsonMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    @Override
    public final JsonException invalidNullArgument(String argName) {
        JsonException result = new JsonException(String.format(this.invalidNullArgument$str(), argName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidNullArgument$str() {
        return invalidNullArgument;
    }

    @Override
    public final JsonException failEncodeToken(Throwable throwable) {
        JsonException result = new JsonException(String.format(this.failEncodeToken$str(), new Object[0]), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failEncodeToken$str() {
        return failEncodeToken;
    }

    @Override
    public final JsonException invalidFormat(String json) {
        JsonException result = new JsonException(String.format(this.invalidFormat$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFormat$str() {
        return invalidFormat;
    }

    @Override
    public final JsonException missingHeader(String header) {
        JsonException result = new JsonException(String.format(this.missingHeader$str(), header));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingHeader$str() {
        return missingHeader;
    }

    @Override
    public final JsonException cryptoNoSuchAlgorithm(String name, Throwable throwable) {
        JsonException result = new JsonException(String.format(this.cryptoNoSuchAlgorithm$str(), name), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoNoSuchAlgorithm$str() {
        return cryptoNoSuchAlgorithm;
    }

    @Override
    public final JsonException cryptoSignatureValidationFailed(Algorithm algorithm, Throwable throwable) {
        JsonException result = new JsonException(String.format(this.cryptoSignatureValidationFailed$str(), new Object[]{algorithm}), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureValidationFailed$str() {
        return cryptoSignatureValidationFailed;
    }

    @Override
    public final JsonException cryptoSignatureFailed(Algorithm algorithm, Throwable throwable) {
        JsonException result = new JsonException(String.format(this.cryptoSignatureFailed$str(), new Object[]{algorithm}), throwable);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureFailed$str() {
        return cryptoSignatureFailed;
    }

    public final JsonException couldNotCreateToken(Class type, Throwable t) {
        JsonException result = new JsonException(String.format(this.couldNotCreateToken$str(), type), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String couldNotCreateToken$str() {
        return couldNotCreateToken;
    }

    @Override
    public final JsonException cryptoInvalidSignature(String json) {
        JsonException result = new JsonException(String.format(this.cryptoInvalidSignature$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoInvalidSignature$str() {
        return cryptoInvalidSignature;
    }

    @Override
    public final JsonException cryptoSignatureNotPresent(String json) {
        JsonException result = new JsonException(String.format(this.cryptoSignatureNotPresent$str(), json));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoSignatureNotPresent$str() {
        return cryptoSignatureNotPresent;
    }

    @Override
    public final JsonException cryptoCouldNotParseKey(String json, Throwable t) {
        JsonException result = new JsonException(String.format(this.cryptoCouldNotParseKey$str(), json), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoCouldNotParseKey$str() {
        return cryptoCouldNotParseKey;
    }

    @Override
    public final JsonException cryptoUnsupportedKey(String keyType) {
        JsonException result = new JsonException(String.format(this.cryptoUnsupportedKey$str(), keyType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cryptoUnsupportedKey$str() {
        return cryptoUnsupportedKey;
    }
}

