/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.json;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.json.key.JSONWebKey;
import org.picketlink.json.key.RSAKey;
import org.picketlink.json.sig.JSONWebSignature;
import org.picketlink.json.sig.JSONWebSignatureHeader;

public class JSONSecurityTestCase {
    @Test
    public void parseJSONWebKey() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("json/jsonWebKey.json");
        Assert.assertNotNull((Object)url);
        File file = new File(url.toURI());
        FileReader reader = new FileReader(file);
        JSONTokener tokener = new JSONTokener((Reader)reader);
        JSONObject json = new JSONObject(tokener);
        Assert.assertNotNull((Object)json);
        System.out.println(json.toString());
        JSONWebKey webKey = new JSONWebKey();
        webKey.parse(json);
        Assert.assertEquals((long)2L, (long)webKey.getKeys().length());
        JSONObject keyObj = webKey.getKey("2011-04-29");
        RSAKey rsa = new RSAKey();
        rsa.parse(keyObj);
        RSAPublicKey publicKey = rsa.convertToPublicKey();
        Assert.assertNotNull((Object)publicKey);
        RSAKey convertedKey = RSAKey.convert((RSAPublicKey)publicKey);
        Assert.assertNotNull((Object)convertedKey);
    }

    @Test
    public void testJSONWebSignature() throws Exception {
        JSONWebSignature sig = new JSONWebSignature();
        String text = "{\"iss\":\"joe\", \"exp\":1300819380, \"http://example.com/is_root\":true}";
        JSONObject payload = new JSONObject(text);
        sig.setPayload(payload);
        JSONWebSignatureHeader header = new JSONWebSignatureHeader("HS256");
        sig.setHeader(header);
        String encodedString = sig.encode();
        System.out.println(encodedString);
        JSONWebSignature decodedString = JSONWebSignature.decode((String)encodedString);
        Assert.assertNotNull((Object)decodedString);
    }
}

