/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.json;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.json.enc.JSONWebEncryption;
import org.picketlink.json.enc.JSONWebEncryptionHeader;

public class JSONWebEncryptionTestCase {
    byte[] contentMasterKey = new byte[]{4, -45, 31, -59, 84, -99, -4, -2, 11, 100, -99, -6, 63, -86, 106, -50, 107, 124, -44, 45, 111, 107, 9, -37, -56, -79, 0, -16, -113, -100, 44, -49};
    byte[] n = new byte[]{-79, 119, 33, 13, -92, 30, 108, 121, -49, -120, 107, -14, 12, -32, 19, -30, -58, -122, 17, 71, -83, 75, 42, 61, 48, -94, -50, -95, 97, 108, -71, -22, -30, -37, 118, -50, 118, 5, -87, -32, 60, -75, 90, 85, 51, 123, 6, -32, 4, 122, 29, -26, -105, 12, -12, 127, 121, 25, 4, 85, -36, -112, -41, 110, -126, 17, 68, -28, -127, -118, 7, -126, -25, 40, -44, -42, 17, -77, 28, 124, -105, -78, -49, 20, 14, -102, -34, 113, -80, 24, -58, 73, -45, 113, 9, 33, -78, 80, 13, 25, 21, 25, -103, -44, -50, 67, -102, -109, 70, -62, -64, -73, -96, 83, 98, -20, -81, 85, 23, 97, 75, -57, -79, 73, -111, 50, -3, -50, 32, -77, -2, -20, -66, 82, 73, 67, -127, -3, -4, -36, 108, -120, -118, 11, -64, 1, 36, -17, -28, 55, 81, 113, 17, 25, -116, 63, -17, -110, 3, -84, 96, 60, -29, -23, 64, -1, -32, -83, -31, -28, -27, 92, 112, 72, 99, 97, 26, 87, -69, 123, 46, 50, 90, -54, 117, 73, 10, -103, 47, -32, -78, -93, 77, 48, 46, -102, 33, -108, 34, -28, 33, -84, -40, 89, 46, -31, 127, 68, -110, -22, 30, -109, 54, -110, 5, -123, 45, 78, -2, 85, 55, 75, -43, 86, -62, -38, -41, -93, -67, -62, 54, 6, 83, 36, 18, -103, 53, 7, 48, 89, 35, 66, -112, 7, 65, -102, 13, 97, 75, 55, -26, -124, 3, 13, -17, 71};
    byte[] e = new byte[]{1, 0, 1};
    byte[] d = new byte[]{84, 80, -106, 58, -91, -21, -14, 123, -39, 55, 38, -102, 36, -75, -35, -100, -45, -41, 100, -92, 90, 88, 40, -28, 83, -108, 54, 122, 4, 16, -91, 48, 76, -62, 26, 107, 51, 53, -77, -91, 31, 18, -58, -83, 78, 61, 56, 97, -4, -98, -116, 80, 63, 25, -33, -100, 36, -53, -42, -4, 120, 67, -76, -89, 3, 82, -13, 25, 97, -42, 83, -123, 69, 16, 104, 54, -96, -56, 41, 83, -92, -69, 70, -103, 111, -22, -14, -98, -81, 28, -58, 48, -45, 45, -108, 58, 23, 62, -29, 74, 52, 117, 42, 90, 41, -7, -126, -102, 80, 119, 61, 26, -63, 40, 125, 10, -104, -82, -29, -31, -51, 32, 62, 66, 6, -93, 100, 99, -37, 19, -3, 25, 105, 80, -55, 29, -4, -99, -19, 69, 1, 80, -85, -89, 20, -60, -100, 109, -7, 88, 0, 3, -104, 38, -91, 72, 87, 6, -104, 71, -100, -42, 16, 71, 30, 82, 51, 103, 76, -38, 63, 9, 84, -93, -7, 91, -41, 44, -18, 85, 101, -16, -108, 1, 82, -32, 91, -121, 105, 127, 84, -85, -75, -104, -46, -73, 126, 24, 46, -60, 90, -83, 38, -11, -37, -70, -34, 27, -16, -44, -62, 15, 66, -121, -30, -78, -66, 52, -11, 74, 65, -32, 81, 100, 85, 25, -52, -91, -53, -69, -81, 84, 100, 82, 15, 11, 23, -54, -105, 107, 54, 41, -49, 3, -120, -27, -122, -125, 93, -117, 50, -74, -52, 93, -126, 89};

    @Test
    public void testJWEUsingRSA15AES128CBC() throws Exception {
        String plainText = "Now is the time for all good men to come to the aid of their country.";
        String headerStr = "{\"alg\":\"RSA1_5\",\"enc\":\"A128CBC\",\"int\":\"HS256\",\"iv\":\"48V1_ALb6US04U3b\"}";
        JSONWebEncryptionHeader header = new JSONWebEncryptionHeader();
        header.load(headerStr);
        RSAPublicKey rsaPublicKey = this.getPublicKey();
        RSAPrivateKey rsaPrivateKey = this.getPrivateKey();
        JSONWebEncryption json = new JSONWebEncryption();
        json.setJsonWebEncryptionHeader(header);
        String encrypted = json.encrypt(plainText, (PublicKey)rsaPublicKey, this.contentMasterKey);
        System.out.println("Encrypted:" + encrypted);
        String cleartext = json.decrypt(encrypted, (PrivateKey)rsaPrivateKey);
        Assert.assertEquals((Object)plainText, (Object)cleartext);
    }

    public RSAPrivateKey getPrivateKey() throws Exception {
        BigInteger N = new BigInteger(1, this.n);
        BigInteger D = new BigInteger(1, this.d);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKeySpec privKeySpec = new RSAPrivateKeySpec(N, D);
        return (RSAPrivateKey)keyFactory.generatePrivate(privKeySpec);
    }

    public RSAPublicKey getPublicKey() throws Exception {
        BigInteger N = new BigInteger(1, this.n);
        BigInteger E = new BigInteger(1, this.e);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(N, E);
        return (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
    }
}

