/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.json;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.json.token.JSONWebToken;
import org.picketlink.test.json.JSONWebEncryptionTestCase;

public class JSONWebTokenAPITestCase {
    @Test
    public void testPlainTextJWTAPI() throws Exception {
        String plainText = "{\"data\":\"Welcome to the world of AES\"}";
        JSONWebToken jwt = new JSONWebToken();
        jwt.setData(new JSONObject(plainText));
        JSONObject header = new JSONObject();
        header.put("alg", (Object)"none");
        jwt.setHeader(header);
        String encodedJWT = jwt.encode();
        System.out.println(encodedJWT);
        jwt = new JSONWebToken();
        jwt.load(encodedJWT);
        Assert.assertEquals((Object)plainText, (Object)jwt.getData().toString());
    }

    @Test
    public void testJWSAPI() throws Exception {
        String headerStr = "{\"typ\":\"JWT\",\"alg\":\"HS256\"}";
        String text = "{\"iss\":\"joe\",\"exp\":1300819380,\"http://example.com/is_root\":true}";
        JSONWebToken jwt = new JSONWebToken();
        jwt.setData(new JSONObject(text));
        JSONObject header = new JSONObject(headerStr);
        jwt.setHeader(header);
        String encodedJWT = jwt.encode();
        System.out.println(encodedJWT);
        jwt = new JSONWebToken();
        jwt.load(encodedJWT);
        Assert.assertEquals((Object)"joe", (Object)jwt.getData().getString("iss"));
    }

    @Test
    public void testJWEAPI() throws Exception {
        String headerStr = "{\"alg\":\"RSA1_5\",\"enc\":\"A128CBC\",\"int\":\"HS256\",\"iv\":\"48V1_ALb6US04U3b\"}";
        String text = "{\"iss\":\"joe\",\"exp\":1300819380,\"http://example.com/is_root\":true}";
        JSONWebEncryptionTestCase jweTest = new JSONWebEncryptionTestCase();
        RSAPublicKey publicKey = jweTest.getPublicKey();
        JSONWebToken jwt = new JSONWebToken();
        jwt.setData(new JSONObject(text));
        jwt.setPublicKey((PublicKey)publicKey);
        JSONObject header = new JSONObject(headerStr);
        jwt.setHeader(header);
        String encodedJWT = jwt.encode();
        System.out.println(encodedJWT);
        jwt = new JSONWebToken();
        jwt.setPrivateKey((PrivateKey)jweTest.getPrivateKey());
        jwt.load(encodedJWT);
        Assert.assertEquals((Object)"joe", (Object)jwt.getData().getString("iss"));
    }
}

