/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.json;

import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.picketlink.json.sig.JSONWebSignature;
import org.picketlink.json.sig.JSONWebSignatureHeader;
import org.picketlink.json.token.JSONWebToken;
import org.picketlink.test.json.JSONWebEncryptionTestCase;

public class JSONWebTokenTestCase {
    @Test
    public void testPlainTextJWT() throws Exception {
        String token = "eyJhbGciOiJub25lIn0=.eyJpc3MiOiJqb2UiLA0KICJleHAiOjEzMDA4MTkzODAsDQogImh0dHA6Ly9leGFtcGxlLmNvbS9pc19yb290Ijp0cnVlfQ==.";
        JSONWebToken jwt = new JSONWebToken();
        jwt.load(token);
        Assert.assertEquals((Object)"{\"alg\":\"none\"}", (Object)jwt.getHeader().toString());
        JSONObject data = jwt.getData();
        Assert.assertEquals((Object)"joe", (Object)data.getString("iss"));
        Assert.assertEquals((Object)"1300819380", (Object)data.getString("exp"));
        Assert.assertEquals((Object)"true", (Object)data.getString("http://example.com/is_root"));
    }

    @Test
    public void testJWTWithMAC() throws Exception {
        String headerStr = "{\"typ\":\"JWT\",\"alg\":\"HS256\"}";
        String text = "{\"iss\":\"joe\",\"exp\":1300819380,\"http://example.com/is_root\":true}";
        JSONWebSignature sig = new JSONWebSignature();
        JSONObject payload = new JSONObject(text);
        sig.setPayload(payload);
        JSONWebSignatureHeader header = JSONWebSignatureHeader.create((String)headerStr);
        sig.setHeader(header);
        String tokenValue = sig.encode();
        JSONWebToken jwt = new JSONWebToken();
        jwt.load(tokenValue);
        JSONObject headerObj = new JSONObject((Object)header);
        JSONObject textObj = new JSONObject(text);
        JSONObject jwtHeader = jwt.getHeader();
        JSONObject jwtData = jwt.getData();
        Assert.assertEquals((Object)headerObj.getString("alg"), (Object)jwtHeader.getString("alg"));
        Assert.assertEquals((Object)textObj.getString("iss"), (Object)jwtData.getString("iss"));
        Assert.assertEquals((Object)textObj.getString("exp"), (Object)jwtData.getString("exp"));
    }

    @Test
    public void testJWTWithEnc() throws Exception {
        String header = "{\"alg\":\"RSA1_5\",\"enc\":\"A128CBC\",\"int\":\"HS256\",\"iv\":\"AxY8DCtDaGlsbGljb3RoZQ\"}";
        String token = "eyJhbGciOiJSU0ExXzUiLCJpdiI6IjQ4VjFfQUxiNlVTMDRVM2IiLCJpbnQiOiJIUzI1NiIsImVuYyI6IkExMjhDQkMifQ==.C6s7/YmGL6P6Cp4ylJIuMo41vHs/OBrmVmuZYQepeq/e8JsE4ffe7g29mvA1BtDUFQwuRDb1BHAPMZaoC8al/4mq4lpeOhxriY1gplKthw1O9/GfiBPP0Yf/Tiyqe9nFQscA00awfV0zLq9qhdZWI3AZJeIZJ8D1JA0rFkbnS/HFHey8iI9KhNIc1zLatnMVjB+vywpK0LmxvmaXXlE59o7khAF1MRwL4e+XTTRm02Q1Ye06HVLbq0dzVmQyPyrnWzoTPduLMxTb/MafS9BN5WdtL8q8DkadQUmA65sOSCcBPaGdxNdWoaOPe8ERYKAqJGtLGRyafZaxd9ldI57GNg==.xpurSbWBpEGuGt4huHJ5ZHhggDV7PASWAz06rgCwCDvc+IgVM6HucUHSCvvvqn5/NVRNS2la2Kva9+7dT1zUPB+HcmgxN7VJs0NKiWS8iZc=.PHEnSewy1m7BwZnQPYPkxTv+bv3/o5Rpf1ToevCaZiU=";
        JSONWebEncryptionTestCase test = new JSONWebEncryptionTestCase();
        RSAPrivateKey privateKey = test.getPrivateKey();
        JSONWebToken jwt = new JSONWebToken();
        jwt.setPrivateKey((PrivateKey)privateKey);
        jwt.load(token);
        JSONObject headerObj = new JSONObject(header);
        JSONObject jwtHeader = jwt.getHeader();
        Assert.assertEquals((Object)headerObj.getString("alg"), (Object)jwtHeader.getString("alg"));
        Assert.assertEquals((Object)"Now is the time for all good men to come to the aid of their country.", (Object)jwt.getPlainText());
    }
}

