/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.key;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.json.JSONException;
import org.json.JSONObject;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.json.PicketLinkJSONMessages;
import org.picketlink.json.key.JSONKey;
import org.picketlink.json.util.PicketLinkJSONUtil;

public class RSAKey
implements JSONKey {
    protected String kid;
    protected String mod;
    protected String exp;
    private JSONKey.KeyUse keyUse;

    public String getAlg() {
        return "RSA";
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getMod() {
        return this.mod;
    }

    public void setMod(String mod) {
        this.mod = mod;
    }

    public String getExp() {
        return this.exp;
    }

    public void setExp(String exp) {
        this.exp = exp;
    }

    public void parse(JSONObject json) throws JSONException {
        String alg = json.getString("alg");
        if (!"RSA".equals(alg)) {
            throw PicketLinkJSONMessages.MESSAGES.wrongJsonKey();
        }
        this.kid = json.getString("kid");
        this.mod = json.getString("mod");
        this.exp = json.getString("exp");
    }

    public JSONObject convert() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("alg", (Object)this.getAlg());
        json.put("exp", (Object)this.exp);
        json.put("mod", (Object)this.mod);
        json.put("kid", (Object)this.kid);
        return json;
    }

    public JSONKey.KeyUse getUse() {
        return this.keyUse;
    }

    public void setUse(JSONKey.KeyUse ku) {
        this.keyUse = ku;
    }

    public static RSAKey convert(RSAPublicKey publicKey) throws ProcessingException {
        BigInteger modulus = publicKey.getModulus();
        BigInteger exponent = publicKey.getPublicExponent();
        RSAKey rsaKey = new RSAKey();
        rsaKey.setMod(PicketLinkJSONUtil.b64Encode((byte[])modulus.toByteArray()));
        rsaKey.setExp(PicketLinkJSONUtil.b64Encode((byte[])exponent.toByteArray()));
        return rsaKey;
    }

    public RSAPublicKey convertToPublicKey() throws ProcessingException {
        BigInteger bigModulus = new BigInteger(1, this.massage(Base64.decode((String)this.mod)));
        BigInteger bigEx = new BigInteger(1, this.massage(Base64.decode((String)this.exp)));
        try {
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("rsa");
            RSAPublicKeySpec kspec = new RSAPublicKeySpec(bigModulus, bigEx);
            return (RSAPublicKey)rsaKeyFactory.generatePublic(kspec);
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    private byte[] massage(byte[] byteArray) {
        if (byteArray[0] == 0) {
            byte[] substring = new byte[byteArray.length - 1];
            System.arraycopy(byteArray, 1, substring, 0, byteArray.length - 1);
            return substring;
        }
        return byteArray;
    }
}

