/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.token;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.json.JSONException;
import org.json.JSONObject;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.json.PicketLinkJSONMessages;
import org.picketlink.json.enc.JSONWebEncryption;
import org.picketlink.json.enc.JSONWebEncryptionHeader;
import org.picketlink.json.sig.JSONWebSignature;
import org.picketlink.json.sig.JSONWebSignatureHeader;
import org.picketlink.json.util.PicketLinkJSONUtil;

public class JSONWebToken {
    private JSONObject header;
    private JSONObject data;
    private String plainText = null;
    private String third = null;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    public void setHeader(JSONObject header) {
        this.header = header;
    }

    public JSONObject getHeader() {
        return this.header;
    }

    public JSONObject getData() {
        return this.data;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String encode() throws ProcessingException {
        if (this.header == null) {
            throw PicketLinkJSONMessages.MESSAGES.jsonWebSignatureHeaderMissing();
        }
        try {
            String alg = this.header.getString("alg");
            if ("none".equals(alg)) {
                String encodedHeader = PicketLinkJSONUtil.b64Encode((String)this.header.toString());
                String encodedText = PicketLinkJSONUtil.b64Encode((String)this.data.toString());
                StringBuilder builder = new StringBuilder();
                builder.append(encodedHeader).append(".").append(encodedText);
                return builder.toString();
            }
            if (this.header.has("enc")) {
                JSONWebEncryption jsonWebEnc = new JSONWebEncryption();
                JSONWebEncryptionHeader encHeader = jsonWebEnc.createHeader();
                encHeader.setDelegate(this.header);
                return jsonWebEnc.encrypt(this.data.toString(), this.publicKey);
            }
            JSONWebSignature jsonWebSignature = new JSONWebSignature();
            JSONWebSignatureHeader jsonSigHeader = new JSONWebSignatureHeader(this.header.getString("alg"));
            jsonWebSignature.setHeader(jsonSigHeader);
            jsonWebSignature.setPayload(this.data);
            return jsonWebSignature.encode();
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    public void decode(String tokenString) throws ProcessingException {
        this.load(tokenString);
    }

    public void load(String tokenString) throws ProcessingException {
        String[] tokens = tokenString.split("\\.");
        String payload = null;
        int len = tokens.length;
        try {
            if (len > 4) {
                throw PicketLinkJSONMessages.MESSAGES.invalidNumberOfTokens(tokens.length);
            }
            String headerStr = new String(Base64.decode((String)tokens[0]));
            this.header = new JSONObject(headerStr);
            if ("none".equals(this.header.getString("alg"))) {
                payload = new String(Base64.decode((String)tokens[1]));
                this.data = new JSONObject(payload);
                return;
            }
            if (this.header.has("enc")) {
                JSONWebEncryption jsonWebEnc = new JSONWebEncryption();
                JSONWebEncryptionHeader encHeader = new JSONWebEncryptionHeader();
                encHeader.load(headerStr);
                jsonWebEnc.setJsonWebEncryptionHeader(encHeader);
                this.plainText = jsonWebEnc.decrypt(tokenString, this.privateKey);
                try {
                    this.data = new JSONObject(this.plainText);
                }
                catch (JSONException ignore) {
                    // empty catch block
                }
                return;
            }
            JSONWebSignature jsonWebSignature = JSONWebSignature.decode((String)tokenString);
            this.header = jsonWebSignature.getHeader().get();
            this.data = jsonWebSignature.getPayload();
        }
        catch (JSONException e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    public void validate() throws ProcessingException {
        try {
            String alg = this.header.getString("alg");
            if ("none".equals(alg)) {
                return;
            }
            if ("HS256".equals(alg)) {
                JSONWebSignature sig = new JSONWebSignature();
                JSONWebSignatureHeader sigHeader = JSONWebSignatureHeader.create((String)this.header.toString());
                sig.setHeader(sigHeader);
                sig.setPayload(this.data);
                String encodedSignature = sig.encode().trim();
                if (!encodedSignature.equals(this.third)) {
                    throw PicketLinkJSONMessages.MESSAGES.doesNotMatch("signatures");
                }
            }
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }
}

