/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.json.util;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.Base64;
import org.picketlink.json.PicketLinkJSONMessages;

public class PicketLinkJSONUtil {
    public static final String AES = "AES";
    public static final String AES_CBC = "AES/CBC/PKCS5Padding";
    public static final String SHA_256 = "SHA-256";

    public static String b64Encode(String str) throws ProcessingException {
        try {
            return Base64.encodeBytes((byte[])str.getBytes("UTF-8"), (int)8);
        }
        catch (UnsupportedEncodingException e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    public static String b64Encode(byte[] str) {
        return Base64.encodeBytes((byte[])str, (int)8);
    }

    public static byte[] encryptUsingAES_CBC(String plainText, byte[] key, IvParameterSpec parameters) throws ProcessingException {
        if (key == null || key.length == 0) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("key");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(AES_CBC);
            SecretKeySpec keyspec = new SecretKeySpec(key, AES);
            cipher.init(1, (Key)keyspec, parameters);
            return cipher.doFinal(plainText.getBytes());
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }

    public static byte[] decryptUsingAES_CBC(byte[] encryptedPlainText, byte[] key, IvParameterSpec parameters) throws ProcessingException {
        if (key == null || key.length == 0) {
            throw PicketLinkJSONMessages.MESSAGES.invalidNullArgument("key");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(AES_CBC);
            SecretKeySpec keyspec = new SecretKeySpec(key, AES);
            cipher.init(2, (Key)keyspec, parameters);
            return cipher.doFinal(encryptedPlainText);
        }
        catch (Exception e) {
            throw PicketLinkJSONMessages.MESSAGES.processingException((Throwable)e);
        }
    }
}

