/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.grants;

import org.picketlink.oauth.common.UUIDGenerator;
import org.picketlink.oauth.common.ValueGenerator;
import org.picketlink.oauth.grants.OAuthGrant;
import org.picketlink.oauth.messages.AccessTokenResponse;

public abstract class AccessTokenEnabledGrant
extends OAuthGrant {
    protected ValueGenerator valueGenerator = new UUIDGenerator();
    protected String accessToken;
    protected String refreshToken;
    protected long accessTokenExpiry = 3600L;
    protected AccessTokenResponse.TokenType tokenType;
    protected String scope;

    public ValueGenerator getValueGenerator() {
        return this.valueGenerator;
    }

    public AccessTokenEnabledGrant setValueGenerator(ValueGenerator valueGenerator) {
        this.valueGenerator = valueGenerator;
        return this;
    }

    public AccessTokenEnabledGrant setAccessTokenExpiry(long expiry) {
        this.accessTokenExpiry = expiry;
        return this;
    }

    public AccessTokenEnabledGrant setAccessToken(String code) {
        this.accessToken = code;
        return this;
    }

    public AccessTokenEnabledGrant setRefreshToken(String code) {
        this.refreshToken = code;
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public AccessTokenResponse.TokenType getTokenType() {
        return this.tokenType;
    }

    public AccessTokenEnabledGrant setTokenType(AccessTokenResponse.TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public AccessTokenEnabledGrant setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public AccessTokenResponse accessTokenResponse() {
        AccessTokenResponse response = new AccessTokenResponse();
        response.setAccessToken(this.accessToken);
        response.setState(this.state);
        response.setTokenType(this.tokenType);
        response.setScope(this.scope);
        response.setExpires(this.accessTokenExpiry);
        return response;
    }
}

