/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.oauth.grants;

import org.picketlink.oauth.grants.AccessTokenEnabledGrant;
import org.picketlink.oauth.messages.AccessTokenRequest;
import org.picketlink.oauth.messages.AccessTokenResponse;
import org.picketlink.oauth.messages.AuthorizationRequest;
import org.picketlink.oauth.messages.AuthorizationResponse;

public class AuthorizationCodeGrant
extends AccessTokenEnabledGrant {
    public static final String GRANT_TYPE = "authorization_code";
    private String state;
    private String authorizationCode;
    private AuthorizationRequest authorizationRequest;
    private AccessTokenRequest accessTokenRequest;

    public AuthorizationCodeGrant setAccessTokenRequest(AccessTokenRequest accessTokenRequest) {
        this.accessTokenRequest = accessTokenRequest;
        return this;
    }

    public AuthorizationCodeGrant setAuthorizationRequest(AuthorizationRequest request) {
        this.authorizationRequest = request;
        this.state = request.getState();
        return this;
    }

    public AuthorizationCodeGrant setAuthorizationCode(String code) {
        this.authorizationCode = code;
        return this;
    }

    public void validate() {
        if (this.authorizationRequest != null) {
            if (!this.authorizationRequest.getResponseType().equals("code")) {
                throw new RuntimeException("response_type should be : code");
            }
            if (this.authorizationRequest.getClientId() == null) {
                throw new RuntimeException("client_id should be present");
            }
        }
        if (this.accessTokenRequest != null) {
            if (this.accessTokenRequest.getGrantType() == null) {
                throw new RuntimeException("grant_type should not be null");
            }
            if (!this.accessTokenRequest.getGrantType().equals(GRANT_TYPE)) {
                throw new RuntimeException("grant_type should be authorization_code");
            }
            if (this.accessTokenRequest.getCode() == null) {
                throw new RuntimeException("code should not be null");
            }
        }
    }

    public AuthorizationResponse authorizationResponse() {
        AuthorizationResponse response = new AuthorizationResponse();
        response.setCode(this.authorizationCode);
        response.setState(this.state);
        return response;
    }

    public AccessTokenResponse accessTokenResponse() {
        AccessTokenResponse response = new AccessTokenResponse();
        response.setAccessToken(this.accessToken);
        response.setRefreshToken(this.refreshToken);
        response.setExpires(this.accessTokenExpiry);
        return response;
    }
}

