/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid.servlets;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openid4java.message.Parameter;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.social.openid.providers.helpers.OpenIDParameterList;
import org.picketlink.social.openid.providers.helpers.OpenIDProtocolContext;
import org.picketlink.social.openid.providers.helpers.OpenIDProviderManager;

public class OpenIDProviderServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient ServletContext servletContext = null;
    private String securePageName = "securepage.jsp";
    private transient PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
        String secpageStr = this.servletContext.getInitParameter("securePage");
        if (secpageStr != null && secpageStr.length() > 0) {
            this.securePageName = secpageStr;
        }
        String configFile = null;
        String configFileStr = this.servletContext.getInitParameter("configFile");
        if (configFileStr != null && configFileStr.length() > 0) {
            try {
                configFile = this.servletContext.getResource(configFileStr).toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.log("configFile=" + configFile);
        this.sts.installDefaultConfiguration(new String[]{configFile});
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OpenIDParameterList requestp;
        HttpSession session = request.getSession();
        OpenIDProtocolContext protoCtx = new OpenIDProtocolContext();
        protoCtx.setEndpoint(String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/provider/");
        if ("complete".equals(request.getParameter("_action"))) {
            requestp = (OpenIDParameterList)((Object)session.getAttribute("parameterlist"));
        } else {
            requestp = new OpenIDParameterList(request.getParameterMap());
            Parameter openidIdentity = requestp.getParameter("openid.identity");
            if (openidIdentity != null) {
                session.setAttribute("openid.identity", (Object)openidIdentity.getValue());
            } else {
                this.log("The Parameter openid.identity is null ");
            }
        }
        protoCtx.setRequestParameterList(requestp);
        String mode = requestp.hasParameter("openid.mode") ? requestp.getParameterValue("openid.mode") : null;
        OpenIDProviderManager.OpenIDMessage responsem = null;
        String responseText = null;
        this.log("mode=" + mode + "::ParameterMap:" + (Object)((Object)requestp));
        if ("associate".equals(mode)) {
            protoCtx.setMode(OpenIDProtocolContext.MODE.ASSOCIATE);
            try {
                this.sts.issueToken((ProtocolContext)protoCtx);
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
            responsem = protoCtx.getResponseMessage();
            responseText = responsem.getResponseText();
        } else if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
            String userSelectedId = null;
            String userSelectedClaimedId = null;
            Boolean authenticatedAndApproved = Boolean.FALSE;
            if (session.getAttribute("authenticatedAndApproved") == null || (Boolean)session.getAttribute("authenticatedAndApproved") == Boolean.FALSE) {
                session.setAttribute("parameterlist", (Object)requestp);
                response.setContentType("text/html");
                response.sendRedirect(String.valueOf(request.getContextPath()) + "/" + this.securePageName);
                return;
            }
            userSelectedId = (String)session.getAttribute("openid.claimed_id");
            userSelectedClaimedId = (String)session.getAttribute("openid.identity");
            authenticatedAndApproved = (Boolean)session.getAttribute("authenticatedAndApproved");
            session.removeAttribute("parameterlist");
            session.setAttribute("authenticatedAndApproved", (Object)Boolean.FALSE);
            if (authenticatedAndApproved == Boolean.TRUE && userSelectedId == null) {
                userSelectedId = userSelectedClaimedId;
            }
            if ("checkid_setup".equals(mode)) {
                protoCtx.setMode(OpenIDProtocolContext.MODE.CHECK_ID_SETUP);
            } else {
                protoCtx.setMode(OpenIDProtocolContext.MODE.CHECK_ID_IMMEDIATE);
            }
            protoCtx.setAuthenticationHolder(new OpenIDProtocolContext.AUTH_HOLDER(userSelectedId, userSelectedClaimedId, authenticatedAndApproved));
            try {
                this.sts.issueToken((ProtocolContext)protoCtx);
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
            responsem = protoCtx.getResponseMessage();
            if (responsem.isSuccessful()) {
                response.sendRedirect(responsem.getDestinationURL(true));
                return;
            }
            responseText = "<pre>" + responsem.getResponseText() + "</pre>";
        } else if ("check_authentication".equals(mode)) {
            try {
                this.sts.validateToken((ProtocolContext)protoCtx);
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
            responsem = protoCtx.getResponseMessage();
            responseText = responsem.getResponseText();
        } else {
            protoCtx.setIssueError(Boolean.TRUE);
            protoCtx.setErrorText("Unknown request");
            try {
                this.sts.issueToken((ProtocolContext)protoCtx);
            }
            catch (ProcessingException e) {
                throw new ServletException((Throwable)e);
            }
            responsem = protoCtx.getResponseMessage();
            responseText = responsem.getResponseText();
        }
        this.log("response=" + responseText);
        response.getWriter().write(responseText);
    }
}

