/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid.auth;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.social.openid.OpenIdPrincipal;
import org.picketlink.social.openid.auth.SecurityActions;
import org.picketlink.social.openid.constants.OpenIDAliasMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenIDProcessor {
    protected static Logger log = Logger.getLogger(OpenIDProcessor.class);
    protected boolean trace = log.isTraceEnabled();
    public static final String AUTH_TYPE = "authType";
    private ConsumerManager openIdConsumerManager;
    private FetchRequest fetchRequest;
    private String openIdServiceUrl = null;
    private String returnURL = null;
    private String requiredAttributes;
    private String optionalAttributes = null;
    private boolean initialized = false;
    protected List<String> roles = new ArrayList<String>();
    public static ThreadLocal<Principal> cachedPrincipal = new ThreadLocal();
    public static ThreadLocal<List<String>> cachedRoles = new ThreadLocal();
    public static String EMPTY_PASSWORD = "EMPTY";

    public OpenIDProcessor(String theReturnURL, String requiredAttributes, String optionalAttributes) {
        this.returnURL = theReturnURL;
        this.requiredAttributes = requiredAttributes;
        this.optionalAttributes = optionalAttributes;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(List<String> requiredRoles) throws MessageException, ConsumerException {
        List tokens;
        if (this.openIdConsumerManager == null) {
            this.openIdConsumerManager = new ConsumerManager();
        }
        this.fetchRequest = FetchRequest.createFetchRequest();
        if (StringUtil.isNotNull((String)this.requiredAttributes)) {
            tokens = StringUtil.tokenize((String)this.requiredAttributes);
            for (String token : tokens) {
                this.fetchRequest.addAttribute(token, OpenIDAliasMapper.get(token), true);
            }
        }
        if (StringUtil.isNotNull((String)this.optionalAttributes)) {
            tokens = StringUtil.tokenize((String)this.optionalAttributes);
            for (String token : tokens) {
                String type = OpenIDAliasMapper.get(token);
                if (type == null) {
                    log.error((Object)("Null Type returned for " + token));
                }
                this.fetchRequest.addAttribute(token, type, false);
            }
        }
        this.roles.addAll(requiredRoles);
        this.initialized = true;
    }

    public boolean prepareAndSendAuthRequest(Request request, Response response) throws IOException {
        String authType = request.getParameter(AUTH_TYPE);
        if (authType == null || authType.length() == 0) {
            authType = (String)request.getSession().getAttribute(AUTH_TYPE);
        }
        this.determineServiceUrl(authType);
        String openId = this.openIdServiceUrl;
        Session session = request.getSessionInternal(true);
        if (openId != null) {
            List discoveries;
            session.setNote("openid", (Object)openId);
            try {
                discoveries = this.openIdConsumerManager.discover(openId);
            }
            catch (DiscoveryException e) {
                throw new RuntimeException(e);
            }
            DiscoveryInformation discovered = this.openIdConsumerManager.associate(discoveries);
            session.setNote("discovery", (Object)discovered);
            try {
                AuthRequest authReq = this.openIdConsumerManager.authenticate(discovered, this.returnURL);
                authReq.addExtension((MessageExtension)this.fetchRequest);
                String url = authReq.getDestinationUrl(true);
                response.sendRedirect(url);
                request.getSession().setAttribute("STATE", (Object)STATES.AUTH.name());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public Principal processIncomingAuthResult(Request request, Response response, Realm realm) throws IOException {
        VerificationResult verification;
        Principal principal = null;
        Session session = request.getSessionInternal(false);
        if (session == null) {
            throw new RuntimeException("wrong lifecycle: session was null");
        }
        ParameterList responseParamList = new ParameterList(request.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)session.getNote("discovery");
        if (discovered == null) {
            throw new RuntimeException("discovered information was null");
        }
        StringBuffer receivingURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(request.getQueryString());
        }
        try {
            verification = this.openIdConsumerManager.verify(receivingURL.toString(), responseParamList, discovered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Identifier identifier = verification.getVerifiedId();
        if (identifier != null) {
            AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
            Map attributes = null;
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                FetchResponse fetchResp;
                try {
                    fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                }
                catch (MessageException e) {
                    throw new RuntimeException(e);
                }
                attributes = fetchResp.getAttributes();
            }
            OpenIdPrincipal openIDPrincipal = this.createPrincipal(identifier.getIdentifier(), discovered.getOPEndpoint(), attributes);
            request.getSession().setAttribute("PRINCIPAL", (Object)openIDPrincipal);
            String principalName = openIDPrincipal.getName();
            cachedPrincipal.set(openIDPrincipal);
            if (this.isJBossEnv()) {
                cachedRoles.set(this.roles);
                principal = realm.authenticate(principalName, EMPTY_PASSWORD);
            } else {
                principal = new GenericPrincipal(realm, principalName, null, this.roles, (Principal)openIDPrincipal);
            }
            if (this.trace) {
                log.trace((Object)("Logged in as:" + principal));
            }
        } else {
            response.sendError(403);
        }
        return principal;
    }

    private OpenIdPrincipal createPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributes) {
        return new OpenIdPrincipal(identifier, openIdProvider, attributes);
    }

    private boolean isJBossEnv() {
        Class<?> clazz = SecurityActions.loadClass(this.getClass(), "org.jboss.as.web.WebServer");
        if (clazz == null) {
            clazz = SecurityActions.loadClass(this.getClass(), "org.jboss.system.Service");
        }
        return clazz != null;
    }

    private void determineServiceUrl(String service) {
        this.openIdServiceUrl = Providers.GOOGLE.get();
        if (StringUtil.isNotNull((String)service)) {
            if ("google".equals(service)) {
                this.openIdServiceUrl = Providers.GOOGLE.get();
            } else if ("yahoo".equals(service)) {
                this.openIdServiceUrl = Providers.YAHOO.get();
            } else if ("myspace".equals(service)) {
                this.openIdServiceUrl = Providers.MYSPACE.get();
            } else if ("myopenid".equals(service)) {
                this.openIdServiceUrl = Providers.MYOPENID.get();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Providers {
        GOOGLE("https://www.google.com/accounts/o8/id"),
        YAHOO("https://me.yahoo.com/"),
        MYSPACE("myspace.com"),
        MYOPENID("https://myopenid.com/");

        private String name;

        private Providers(String name) {
            this.name = name;
        }

        String get() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

