/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid.providers;

import javax.xml.namespace.QName;
import org.jboss.security.xacml.sunxacml.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.AbstractSecurityTokenProvider;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.social.openid.providers.helpers.OpenIDParameterList;
import org.picketlink.social.openid.providers.helpers.OpenIDProtocolContext;
import org.picketlink.social.openid.providers.helpers.OpenIDProviderManager;
import org.picketlink.social.openid.providers.helpers.OpenIDTokenRegistryStore;

public class OpenIDTokenProvider
extends AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    public static final String OPENID_1_0_NS = "urn:openid:1:0";
    public static final String OPENID_1_1_NS = "urn:openid:1:1";
    public static final String OPENID_2_0_NS = "urn:openid:2:0";
    protected static OpenIDProviderManager serverManager = null;

    public boolean supports(String namespace) {
        return OPENID_1_0_NS.equals(namespace);
    }

    public String tokenType() {
        return OPENID_1_0_NS;
    }

    public QName getSupportedQName() {
        return new QName(OPENID_1_0_NS);
    }

    public String family() {
        return SecurityTokenProvider.FAMILY_TYPE.OPENID.name();
    }

    public void issueToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OpenIDProtocolContext)) {
            return;
        }
        this.check();
        OpenIDProtocolContext openIDProtoCtx = (OpenIDProtocolContext)context;
        if (serverManager.getEndPoint() == null) {
            serverManager.setEndPoint(openIDProtoCtx.getEndpoint());
        }
        OpenIDParameterList requestp = openIDProtoCtx.getRequestParameterList();
        OpenIDProviderManager.OpenIDMessage responsem = null;
        if (openIDProtoCtx.getIssueError().booleanValue()) {
            String errorText = openIDProtoCtx.getErrorText() == null ? "Unknown request" : openIDProtoCtx.getErrorText();
            responsem = serverManager.getDirectError(errorText);
        } else {
            OpenIDProtocolContext.MODE mode = openIDProtoCtx.getMode();
            switch (mode) {
                case ASSOCIATE: {
                    responsem = serverManager.processAssociationRequest(requestp);
                    break;
                }
                case CHECK_AUTHENTICATION: {
                    this.validateToken(openIDProtoCtx);
                    return;
                }
                case CHECK_ID_SETUP: 
                case CHECK_ID_IMMEDIATE: {
                    OpenIDProtocolContext.AUTH_HOLDER authHolder = openIDProtoCtx.getAuthenticationHolder();
                    if (authHolder == null) {
                        throw new ProcessingException("Authentication Holder is null");
                    }
                    responsem = serverManager.processAuthenticationRequest(requestp, authHolder.getUserSelectedId(), authHolder.getUserSelectedClaimedId(), authHolder.isAuthenticatedAndApproved());
                    break;
                }
                default: {
                    throw new ProcessingException("Unknown mode");
                }
            }
        }
        openIDProtoCtx.setResponseMessage(responsem);
    }

    public void renewToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OpenIDProtocolContext)) {
            return;
        }
        this.check();
    }

    public void cancelToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OpenIDProtocolContext)) {
            return;
        }
        this.check();
    }

    public void validateToken(ProtocolContext context) throws ProcessingException {
        if (!(context instanceof OpenIDProtocolContext)) {
            return;
        }
        this.check();
        OpenIDProtocolContext openIDProtoCtx = (OpenIDProtocolContext)context;
        if (serverManager.getEndPoint() == null) {
            serverManager.setEndPoint(openIDProtoCtx.getEndpoint());
        }
        OpenIDParameterList requestp = openIDProtoCtx.getRequestParameterList();
        OpenIDProviderManager.OpenIDMessage responsem = serverManager.verify(requestp);
        openIDProtoCtx.setResponseMessage(responsem);
    }

    protected void check() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        if (serverManager == null) {
            serverManager = new OpenIDProviderManager();
            serverManager.initialize(new OpenIDTokenRegistryStore(), new OpenIDTokenRegistryStore());
        }
    }
}

