/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.ObjectFactory;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;

@Name(value="org.picketlink.identity.seam.federation.samlMetaDataProvider")
@AutoCreate
public class SamlMetaDataProvider {
    @In
    private ServiceProvider serviceProvider;

    public void writeMetaData(OutputStream stream) {
        try {
            JAXBElement X509Certificate2;
            org.picketlink.identity.federation.saml.v2.metadata.ObjectFactory metaDataFactory = new org.picketlink.identity.federation.saml.v2.metadata.ObjectFactory();
            IndexedEndpointType acsRedirectEndpoint = metaDataFactory.createIndexedEndpointType();
            acsRedirectEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            acsRedirectEndpoint.setLocation(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_ASSERTION_CONSUMER_SERVICE));
            IndexedEndpointType acsPostEndpoint = metaDataFactory.createIndexedEndpointType();
            acsPostEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            acsPostEndpoint.setLocation(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_ASSERTION_CONSUMER_SERVICE));
            IndexedEndpointType sloRedirectEndpoint = metaDataFactory.createIndexedEndpointType();
            sloRedirectEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            sloRedirectEndpoint.setLocation(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_SINGLE_LOGOUT_SERVICE));
            IndexedEndpointType sloPostEndpoint = metaDataFactory.createIndexedEndpointType();
            sloPostEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            sloPostEndpoint.setLocation(this.serviceProvider.getServiceURL(ExternalAuthenticationService.SAML_SINGLE_LOGOUT_SERVICE));
            SPSSODescriptorType spSsoDescriptor = metaDataFactory.createSPSSODescriptorType();
            spSsoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(this.serviceProvider.getSamlConfiguration().isAuthnRequestsSigned()));
            spSsoDescriptor.setWantAssertionsSigned(Boolean.valueOf(this.serviceProvider.getSamlConfiguration().isWantAssertionsSigned()));
            spSsoDescriptor.getAssertionConsumerService().add(acsRedirectEndpoint);
            spSsoDescriptor.getAssertionConsumerService().add(acsPostEndpoint);
            spSsoDescriptor.getSingleLogoutService().add(sloRedirectEndpoint);
            spSsoDescriptor.getSingleLogoutService().add(sloPostEndpoint);
            spSsoDescriptor.getProtocolSupportEnumeration().add(JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            spSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
            spSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
            spSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:unspecified");
            spSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress");
            ObjectFactory signatureFactory = new ObjectFactory();
            X509Certificate certificate = this.serviceProvider.getSamlConfiguration().getCertificate();
            try {
                X509Certificate2 = signatureFactory.createX509DataTypeX509Certificate(certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            X509DataType X509Data = signatureFactory.createX509DataType();
            X509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(X509Certificate2);
            KeyInfoType keyInfo = signatureFactory.createKeyInfoType();
            keyInfo.getContent().add(signatureFactory.createX509Data(X509Data));
            KeyDescriptorType keyDescriptor = metaDataFactory.createKeyDescriptorType();
            keyDescriptor.setUse(KeyTypes.SIGNING);
            keyDescriptor.setKeyInfo(keyInfo);
            spSsoDescriptor.getKeyDescriptor().add(keyDescriptor);
            EntityDescriptorType entityDescriptor = metaDataFactory.createEntityDescriptorType();
            entityDescriptor.setEntityID(this.serviceProvider.getSamlConfiguration().getEntityId());
            entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add(spSsoDescriptor);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.picketlink.identity.federation.saml.v2.metadata");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)metaDataFactory.createEntityDescriptor(entityDescriptor), stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

