/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.protocol.ObjectFactory;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.seam.federation.RequestOrResponse;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.configuration.Binding;
import org.picketlink.identity.seam.federation.configuration.SamlEndpoint;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.configuration.SamlService;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Name(value="org.picketlink.identity.seam.federation.samlMessageSender")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlMessageSender {
    @Logger
    private Log log;
    @In
    private ServiceProvider serviceProvider;

    public void sendRequestToIDP(HttpServletRequest request, HttpServletResponse response, SamlIdentityProvider samlIdentityProvider, SamlProfile profile, RequestAbstractType samlRequest) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document message = null;
        SamlEndpoint endpoint = null;
        try {
            SamlService service = samlIdentityProvider.getService(profile);
            endpoint = service.getEndpointForBinding(Binding.HTTP_Post);
            if (endpoint == null) {
                endpoint = service.getEndpointForBinding(Binding.HTTP_Redirect);
            }
            if (endpoint == null) {
                throw new RuntimeException("Idp " + samlIdentityProvider.getEntityId() + " has no endpoint found for profile " + (Object)((Object)profile));
            }
            SAML2Request saml2Request = new SAML2Request();
            samlRequest.setDestination(endpoint.getLocation());
            saml2Request.marshall(samlRequest, (OutputStream)baos);
            message = saml2Request.convert(samlRequest);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.sendMessageToIDP(request, response, samlIdentityProvider, message, RequestOrResponse.REQUEST, endpoint);
    }

    public void sendResponseToIDP(HttpServletRequest request, HttpServletResponse response, SamlIdentityProvider samlIdentityProvider, SamlEndpoint endpoint, StatusResponseType samlResponse) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document message = null;
        try {
            samlResponse.setDestination(endpoint.getResponseLocation());
            if (!endpoint.getService().getProfile().equals((Object)SamlProfile.SINGLE_LOGOUT)) {
                throw new RuntimeException("Responses can currently only be created for the single logout service");
            }
            JAXBElement responseElement = new ObjectFactory().createLogoutResponse(samlResponse);
            JAXBContext jaxbContext = JAXBUtil.getJAXBContext(RequestAbstractType.class);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)responseElement, (OutputStream)baos);
            Binder binder = jaxbContext.createBinder();
            message = DocumentUtil.createDocument();
            binder.marshal((Object)responseElement, (Object)message);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.sendMessageToIDP(request, response, samlIdentityProvider, message, RequestOrResponse.RESPONSE, endpoint);
    }

    private void sendMessageToIDP(HttpServletRequest request, HttpServletResponse response, SamlIdentityProvider samlIdentityProvider, Document message, RequestOrResponse requestOrResponse, SamlEndpoint endpoint) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending over to IDP: " + DocumentUtil.asString((Document)message)), new Object[0]);
        }
        try {
            boolean signMessage = endpoint.getService().getProfile().equals((Object)SamlProfile.SINGLE_SIGN_ON) ? samlIdentityProvider.isWantAuthnRequestsSigned() : samlIdentityProvider.isWantSingleLogoutMessagesSigned();
            PrivateKey privateKey = this.serviceProvider.getSamlConfiguration().getPrivateKey();
            if (endpoint.getBinding() == Binding.HTTP_Redirect) {
                byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)message).getBytes("UTF-8");
                String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode((byte[])responseBytes);
                String finalDest = endpoint.getLocation() + this.getQueryString(urlEncodedResponse, null, signMessage, requestOrResponse, privateKey);
                HTTPRedirectUtil.sendRedirectForResponder((String)finalDest, (HttpServletResponse)response);
            } else {
                if (signMessage) {
                    SAML2Signature samlSignature = new SAML2Signature();
                    PublicKey publicKey = this.serviceProvider.getSamlConfiguration().getCertificate().getPublicKey();
                    samlSignature.signSAMLDocument(message, new KeyPair(publicKey, privateKey));
                }
                byte[] responseBytes = DocumentUtil.getDocumentAsString((Document)message).getBytes("UTF-8");
                String samlResponse = PostBindingUtil.base64Encode((String)new String(responseBytes));
                PostBindingUtil.sendPost((DestinationInfoHolder)new DestinationInfoHolder(endpoint.getLocation(), samlResponse, null), (HttpServletResponse)response, (boolean)requestOrResponse.isRequest());
            }
        }
        catch (ConfigurationException e) {
            throw new RuntimeException();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getQueryString(String urlEncodedSamlMessage, String urlEncodedRelayState, boolean supportSignature, RequestOrResponse requestOrResponse, PrivateKey signingKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("?");
        if (supportSignature) {
            try {
                sb.append(RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature((String)urlEncodedSamlMessage, (String)urlEncodedRelayState, (PrivateKey)signingKey));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (requestOrResponse == RequestOrResponse.REQUEST) {
                sb.append("SAMLRequest");
            } else {
                sb.append("SAMLResponse");
            }
            sb.append("=").append(urlEncodedSamlMessage);
            if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
                sb.append("&").append("RelayState").append("=").append(urlEncodedRelayState);
            }
        }
        return sb.toString();
    }
}

