/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.security.Identity;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.RequestContext;
import org.picketlink.identity.seam.federation.SamlMessageFactory;
import org.picketlink.identity.seam.federation.SamlMessageSender;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.configuration.Binding;
import org.picketlink.identity.seam.federation.configuration.SamlEndpoint;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

@Name(value="org.picketlink.identity.seam.federation.samlSingleLogoutReceiver")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlSingleLogoutReceiver {
    @In
    private SamlMessageFactory samlMessageFactory;
    @In
    private SamlMessageSender samlMessageSender;
    @In
    private Identity identity;
    @In
    private ServiceProvider serviceProvider;

    public void processIDPRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestAbstractType request, SamlIdentityProvider idp) throws InvalidRequestException {
        if (!(request instanceof LogoutRequestType)) {
            throw new InvalidRequestException("Request should be a single logout request.");
        }
        if (!this.identity.isLoggedIn()) {
            throw new InvalidRequestException("No active session to logout.");
        }
        Identity.instance().logout();
        StatusResponseType response = this.samlMessageFactory.createStatusResponse(request, JBossSAMLURIConstants.STATUS_SUCCESS.get(), null);
        Binding binding = httpRequest.getMethod().equals("POST") ? Binding.HTTP_Post : Binding.HTTP_Redirect;
        SamlEndpoint endpoint = idp.getService(SamlProfile.SINGLE_LOGOUT).getEndpointForBinding(binding);
        this.samlMessageSender.sendResponseToIDP(httpRequest, httpResponse, idp, endpoint, response);
    }

    public void processIDPResponse(HttpServletRequest httpRequest, HttpServletResponse httpResponse, StatusResponseType response, RequestContext requestContext, SamlIdentityProvider idp) {
        if (response.getStatus() == null || !response.getStatus().getStatusCode().getValue().equals(JBossSAMLURIConstants.STATUS_SUCCESS.get())) {
            throw new RuntimeException("Single logout failed. Status code: " + (response.getStatus() == null ? "null" : response.getStatus().getStatusCode().getValue()));
        }
        Identity.instance().logout();
        try {
            httpResponse.sendRedirect(this.serviceProvider.getLoggedOutUrl());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

