/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation.configuration;

import java.util.LinkedList;
import java.util.List;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.configuration.Binding;
import org.picketlink.identity.seam.federation.configuration.SamlEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlService {
    private SamlProfile profile;
    private List<SamlEndpoint> serviceEndpoints = new LinkedList<SamlEndpoint>();

    public SamlService(SamlProfile profile, List<EndpointType> endpoints) {
        this.profile = profile;
        for (EndpointType endpoint : endpoints) {
            Binding binding = null;
            if (endpoint.getBinding().endsWith("HTTP-Redirect")) {
                binding = Binding.HTTP_Redirect;
            } else if (endpoint.getBinding().endsWith("HTTP-POST")) {
                binding = Binding.HTTP_Post;
            }
            if (binding == null) continue;
            SamlEndpoint samlEndpoint = new SamlEndpoint(this, binding, endpoint.getLocation(), endpoint.getResponseLocation());
            this.serviceEndpoints.add(samlEndpoint);
        }
    }

    public SamlProfile getProfile() {
        return this.profile;
    }

    public List<SamlEndpoint> getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public SamlEndpoint getEndpointForBinding(Binding binding) {
        for (SamlEndpoint endpoint : this.serviceEndpoints) {
            if (endpoint.getBinding() != binding) continue;
            return endpoint;
        }
        return null;
    }
}

