/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.security.Principal;
import java.util.LinkedList;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.Events;
import org.jboss.seam.security.Identity;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

@Name(value="org.picketlink.identity.seam.federation.internalAuthenticator")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class InternalAuthenticator {
    @In
    private Identity identity;
    @In
    private ServiceProvider serviceProvider;

    public boolean authenticate(Principal principal, HttpServletRequest httpRequest) {
        LinkedList roles = new LinkedList();
        Boolean internallyAuthenticated = (Boolean)this.serviceProvider.getInternalAuthenticationMethod().invoke(new Object[]{principal, roles});
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.security.postAuthenticate", new Object[]{this.identity});
        }
        if (internallyAuthenticated.booleanValue()) {
            this.identity.acceptExternallyAuthenticatedPrincipal(principal);
            for (String role : roles) {
                this.identity.addRole(role);
            }
            if (Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.security.loginSuccessful", new Object[0]);
            }
        } else if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.security.loginFailed", new Object[]{new LoginException()});
        }
        return internallyAuthenticated;
    }
}

