/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.Events;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchResponse;
import org.picketlink.identity.seam.federation.InternalAuthenticator;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.OpenIdPrincipal;
import org.picketlink.identity.seam.federation.OpenIdRequest;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.picketlink.identity.seam.federation.openIdSingleLoginReceiver")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class OpenIdSingleLoginReceiver {
    @In
    private OpenIdRequest openIdRequest;
    @In
    private ConsumerManager openIdConsumerManager;
    @In
    private InternalAuthenticator internalAuthenticator;
    @In
    private ServiceProvider serviceProvider;

    public void handleIncomingMessage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InvalidRequestException {
        try {
            ParameterList response = new ParameterList(httpRequest.getParameterMap());
            DiscoveryInformation discovered = this.openIdRequest.getDiscoveryInformation();
            StringBuffer receivingURL = httpRequest.getRequestURL();
            String queryString = httpRequest.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(httpRequest.getQueryString());
            }
            VerificationResult verification = this.openIdConsumerManager.verify(receivingURL.toString(), response, discovered);
            boolean authenticated = true;
            Identifier identifier = verification.getVerifiedId();
            if (identifier != null) {
                AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
                Map attributes = null;
                if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0")) {
                    FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0");
                    attributes = fetchResp.getAttributes();
                }
                OpenIdPrincipal principal = this.createPrincipal(identifier.getIdentifier(), discovered.getOPEndpoint(), attributes);
                authenticated = this.internalAuthenticator.authenticate(principal, httpRequest);
            } else {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.security.loginFailed", new Object[]{new LoginException()});
                }
                authenticated = false;
            }
            if (authenticated) {
                httpResponse.sendRedirect(this.openIdRequest.getReturnUrl());
            } else {
                httpResponse.sendRedirect(this.serviceProvider.getFailedAuthenticationUrl());
            }
        }
        catch (OpenIDException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OpenIdPrincipal createPrincipal(String identifier, URL openIdProvider, Map<String, List<String>> attributes) {
        return new OpenIdPrincipal(identifier, openIdProvider, attributes);
    }
}

