/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.Events;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.OpenIdRequest;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.picketlink.identity.seam.federation.jaxb.config.OpenIdAttributeType;

@Name(value="org.picketlink.identity.seam.federation.openIdSingleLoginSender")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class OpenIdSingleLoginSender {
    @In
    private OpenIdRequest openIdRequest;
    @In
    private ConsumerManager openIdConsumerManager;
    @In
    private ServiceProvider serviceProvider;

    public String sendAuthRequest(String openId, String returnUrl, HttpServletResponse httpResponse) {
        try {
            List discoveries = this.openIdConsumerManager.discover(openId);
            DiscoveryInformation discovered = this.openIdConsumerManager.associate(discoveries);
            this.openIdRequest.setDiscoveryInformation(discovered);
            this.openIdRequest.setReturnUrl(returnUrl);
            String openIdServiceUrl = this.serviceProvider.getServiceURL(ExternalAuthenticationService.OPEN_ID_SERVICE);
            String realm = this.serviceProvider.getOpenIdRealm();
            AuthRequest authReq = this.openIdConsumerManager.authenticate(discovered, openIdServiceUrl, realm);
            List<OpenIdAttributeType> attributes = this.serviceProvider.getOpenIdConfiguration().getAttributes();
            if (attributes.size() > 0) {
                FetchRequest fetch = FetchRequest.createFetchRequest();
                for (OpenIdAttributeType attribute : attributes) {
                    fetch.addAttribute(attribute.getAlias(), attribute.getTypeUri(), attribute.isRequired());
                }
                authReq.addExtension((MessageExtension)fetch);
            }
            String url = authReq.getDestinationUrl(true);
            if (Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.security.preAuthenticate", new Object[0]);
            }
            httpResponse.sendRedirect(url);
        }
        catch (OpenIDException e) {
            try {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.security.loginFailed", new Object[0]);
                }
                httpResponse.sendRedirect(this.serviceProvider.getFailedAuthenticationUrl());
            }
            catch (IOException e1) {
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

