/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.picketlink.identity.seam.federation.jaxb.xrds.ObjectFactory;
import org.picketlink.identity.seam.federation.jaxb.xrds.Service;
import org.picketlink.identity.seam.federation.jaxb.xrds.Type;
import org.picketlink.identity.seam.federation.jaxb.xrds.URIPriorityAppendPattern;
import org.picketlink.identity.seam.federation.jaxb.xrds.XRD;
import org.picketlink.identity.seam.federation.jaxb.xrds.XRDS;

@Name(value="org.picketlink.identity.seam.federation.openIdXrdsProvider")
@AutoCreate
public class OpenIdXrdsProvider {
    @In
    private ServiceProvider serviceProvider;

    public void writeMetaData(OutputStream stream) {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            XRDS xrds = objectFactory.createXRDS();
            XRD xrd = objectFactory.createXRD();
            Type type = objectFactory.createType();
            type.setValue("http://specs.openid.net/auth/2.0/return_to");
            URIPriorityAppendPattern uri = objectFactory.createURIPriorityAppendPattern();
            uri.setValue(this.serviceProvider.getServiceURL(ExternalAuthenticationService.OPEN_ID_SERVICE));
            Service service = objectFactory.createService();
            service.getType().add(type);
            service.getURI().add(uri);
            xrd.getService().add(service);
            xrds.getOtherelement().add(xrd);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.picketlink.identity.seam.federation.jaxb.xrds");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xrds, stream);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

