/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.jboss.seam.util.Base64;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.seam.federation.InvalidRequestException;
import org.picketlink.identity.seam.federation.RequestContext;
import org.picketlink.identity.seam.federation.RequestOrResponse;
import org.picketlink.identity.seam.federation.Requests;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.SamlSignatureValidator;
import org.picketlink.identity.seam.federation.SamlSingleLogoutReceiver;
import org.picketlink.identity.seam.federation.SamlSingleSignOnReceiver;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Name(value="org.picketlink.identity.seam.federation.samlMessageReceiver")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlMessageReceiver {
    @Logger
    private Log log;
    @In
    private Requests requests;
    @In
    private SamlSingleLogoutReceiver samlSingleLogoutReceiver;
    @In
    private SamlSingleSignOnReceiver samlSingleSignOnReceiver;
    @In
    private SamlSignatureValidator samlSignatureValidator;
    @In
    private ServiceProvider serviceProvider;

    public void handleIncomingSamlMessage(SamlProfile samlProfile, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InvalidRequestException {
        SamlIdentityProvider idp;
        String issuerEntityId;
        RequestOrResponse requestOrResponse;
        String samlMessage;
        String samlRequestParam = httpRequest.getParameter("SAMLRequest");
        String samlResponseParam = httpRequest.getParameter("SAMLResponse");
        if (samlRequestParam != null && samlResponseParam == null) {
            samlMessage = samlRequestParam;
            requestOrResponse = RequestOrResponse.REQUEST;
        } else if (samlRequestParam == null && samlResponseParam != null) {
            samlMessage = samlResponseParam;
            requestOrResponse = RequestOrResponse.RESPONSE;
        } else {
            throw new InvalidRequestException("SAML message should either have a SAMLRequest parameter or a SAMLResponse parameter");
        }
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        if (httpRequest.getMethod().equals("POST")) {
            byte[] decodedMessage = Base64.decode((String)samlMessage);
            is = new ByteArrayInputStream(decodedMessage);
        } else {
            is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        }
        Document document = this.getDocument(is);
        RequestAbstractType samlRequest = null;
        StatusResponseType samlResponse = null;
        if (requestOrResponse.isRequest()) {
            samlRequest = this.getSamlRequest(document);
            issuerEntityId = samlRequest.getIssuer().getValue();
        } else {
            samlResponse = this.getSamlResponse(document);
            issuerEntityId = samlResponse.getIssuer().getValue();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received from IDP: " + DocumentUtil.asString((Document)document)), new Object[0]);
        }
        if ((idp = this.serviceProvider.getSamlConfiguration().getSamlIdentityProviderByEntityId(issuerEntityId)) == null) {
            throw new InvalidRequestException("Received message from unknown idp " + issuerEntityId);
        }
        boolean validate = samlProfile == SamlProfile.SINGLE_SIGN_ON ? this.serviceProvider.getSamlConfiguration().isWantAssertionsSigned() : idp.isSingleLogoutMessagesSigned();
        if (validate) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Validating the signature", new Object[0]);
            }
            if (httpRequest.getMethod().equals("POST")) {
                this.samlSignatureValidator.validateSignatureForPostBinding(idp, document);
            } else {
                this.samlSignatureValidator.validateSignatureForRedirectBinding(idp, httpRequest, requestOrResponse);
            }
        }
        RequestContext requestContext = null;
        if (requestOrResponse.isResponse() && samlResponse.getInResponseTo() != null) {
            requestContext = this.requests.getRequest(samlResponse.getInResponseTo());
            if (requestContext == null) {
                throw new InvalidRequestException("No request that corresponds with the received response");
            }
            if (!requestContext.getIdentityProvider().equals(idp)) {
                throw new InvalidRequestException("Identity provider of request and response do not match");
            }
        }
        if (samlProfile == SamlProfile.SINGLE_SIGN_ON) {
            if (requestOrResponse.isRequest()) {
                throw new InvalidRequestException("Assertion consumer service can only process SAML responses");
            }
            this.samlSingleSignOnReceiver.processIDPResponse(httpRequest, httpResponse, samlResponse, requestContext, idp);
        } else if (requestOrResponse.isRequest()) {
            this.samlSingleLogoutReceiver.processIDPRequest(httpRequest, httpResponse, samlRequest, idp);
        } else {
            this.samlSingleLogoutReceiver.processIDPResponse(httpRequest, httpResponse, samlResponse, requestContext, idp);
        }
    }

    private RequestAbstractType getSamlRequest(Document document) throws InvalidRequestException {
        try {
            JAXBContext jaxb = JAXBUtil.getJAXBContext(StatusResponseType.class);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            JAXBElement jaxbRequest = (JAXBElement)unmarshaller.unmarshal((Node)document);
            RequestAbstractType request = (RequestAbstractType)jaxbRequest.getValue();
            return request;
        }
        catch (JAXBException e) {
            throw new InvalidRequestException("SAML message could not be parsed", (Exception)((Object)e));
        }
    }

    private StatusResponseType getSamlResponse(Document document) throws InvalidRequestException {
        try {
            JAXBContext jaxb = JAXBUtil.getJAXBContext(StatusResponseType.class);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            JAXBElement jaxbResponseType = (JAXBElement)unmarshaller.unmarshal((Node)document);
            StatusResponseType statusResponse = (StatusResponseType)jaxbResponseType.getValue();
            return statusResponse;
        }
        catch (JAXBException e) {
            throw new InvalidRequestException("SAML message could not be parsed", (Exception)((Object)e));
        }
    }

    private Document getDocument(InputStream is) throws InvalidRequestException {
        try {
            return DocumentUtil.getDocument((InputStream)is);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (ParsingException e) {
            throw new InvalidRequestException("SAML request could not be parsed", (Exception)((Object)e));
        }
    }
}

