/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.Events;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.seam.federation.Requests;
import org.picketlink.identity.seam.federation.SamlMessageFactory;
import org.picketlink.identity.seam.federation.SamlMessageSender;
import org.picketlink.identity.seam.federation.SamlProfile;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;

@Name(value="org.picketlink.identity.seam.federation.samlSingleSignOnSender")
@AutoCreate
@Import(value={"org.picketlink.identity.seam.federation"})
public class SamlSingleSignOnSender {
    @In
    private Requests requests;
    @In
    private SamlMessageFactory samlMessageFactory;
    @In
    private SamlMessageSender samlMessageSender;

    public void sendAuthenticationRequestToIDP(HttpServletRequest request, HttpServletResponse response, SamlIdentityProvider samlIdentityProvider, String returnUrl) {
        AuthnRequestType authnRequest = this.samlMessageFactory.createAuthnRequest();
        this.requests.addRequest(authnRequest.getID(), samlIdentityProvider, returnUrl);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.security.preAuthenticate", new Object[0]);
        }
        this.samlMessageSender.sendRequestToIDP(request, response, samlIdentityProvider, SamlProfile.SINGLE_SIGN_ON, (RequestAbstractType)authnRequest);
    }
}

