/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation.configuration;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Import;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.web.ServletContexts;
import org.picketlink.identity.seam.federation.configuration.ServiceProvider;
import org.picketlink.identity.seam.federation.jaxb.config.ExternalAuthenticationConfigType;
import org.picketlink.identity.seam.federation.jaxb.config.ServiceProviderType;
import org.xml.sax.SAXException;

@Name(value="org.picketlink.identity.seam.federation.configuration")
@Scope(value=ScopeType.APPLICATION)
@AutoCreate
@Startup
@Import(value={"org.picketlink.identity.seam.federation"})
public class Configuration {
    private static final String CONFIGURATION_FILE = "/external-authentication-config.xml";
    private String contextRoot;
    private Map<String, ServiceProvider> serviceProviderMap = new HashMap<String, ServiceProvider>();

    @Create
    public void init() {
        LinkedList<ServiceProvider> serviceProviders = new LinkedList<ServiceProvider>();
        ExternalAuthenticationConfigType externalAuthenticationConfig = this.readConfigurationFile();
        for (ServiceProviderType serviceProvider : externalAuthenticationConfig.getServiceProvider()) {
            serviceProviders.add(new ServiceProvider(this, serviceProvider));
        }
        for (ServiceProvider sp : serviceProviders) {
            if (this.serviceProviderMap.containsKey(sp.getHostname())) {
                throw new RuntimeException("Two service providers have the same hostname");
            }
            this.serviceProviderMap.put(sp.getHostname(), sp);
        }
    }

    private ExternalAuthenticationConfigType readConfigurationFile() {
        ExternalAuthenticationConfigType externalAuthenticationConfig;
        try {
            Schema schema;
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.picketlink.identity.seam.federation.jaxb.config");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            URL schemaURL = this.getClass().getResource("/schema/config/external-authentication-config.xsd");
            try {
                schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            unmarshaller.setSchema(schema);
            JAXBElement o = (JAXBElement)unmarshaller.unmarshal(this.getClass().getResource(CONFIGURATION_FILE));
            externalAuthenticationConfig = (ExternalAuthenticationConfigType)o.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return externalAuthenticationConfig;
    }

    public static Configuration instance() {
        return (Configuration)Component.getInstance(Configuration.class);
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    @Factory(scope=ScopeType.EVENT, autoCreate=true, value="org.picketlink.identity.seam.federation.serviceProvider")
    public ServiceProvider getServiceProvider() {
        String hostname = ServletContexts.instance().getRequest().getServerName();
        return this.serviceProviderMap.get(hostname);
    }

    public ServiceProvider getServiceProvider(String hostname) {
        return this.serviceProviderMap.get(hostname);
    }
}

