/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.picketlink.identity.seam.federation.configuration.SamlIdentityProvider;
import org.picketlink.identity.seam.federation.jaxb.config.SamlConfigType;
import org.picketlink.identity.seam.federation.jaxb.config.SamlIdentityProviderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlConfiguration {
    private static final String SAML_ENTITIES_FILE = "/saml-entities.xml";
    private Map<String, IDPSSODescriptorType> idpMetaInfo = new HashMap<String, IDPSSODescriptorType>();
    private String entityId;
    private SamlIdentityProvider defaultIdentityProvider;
    private List<SamlIdentityProvider> identityProviders = new LinkedList<SamlIdentityProvider>();
    private boolean authnRequestsSigned = false;
    private boolean wantAssertionsSigned = false;
    private PrivateKey privateKey;
    private X509Certificate certificate;

    public SamlConfiguration(SamlConfigType samlConfig) {
        this.readSamlMetaInformation();
        this.entityId = samlConfig.getServiceProviderEntityId();
        this.authnRequestsSigned = samlConfig.isAuthnRequestsSigned();
        this.wantAssertionsSigned = samlConfig.isWantAssertionsSigned();
        for (SamlIdentityProviderType samlIdp : samlConfig.getSamlIdentityProvider()) {
            IDPSSODescriptorType idpSsoDescriptor = this.idpMetaInfo.get(samlIdp.getEntityId());
            if (idpSsoDescriptor == null) {
                throw new RuntimeException("Saml identity provider with entity id \"" + samlIdp.getEntityId() + "\" not found in metadata.");
            }
            SamlIdentityProvider samlIdentityProvider = new SamlIdentityProvider(samlIdp.getEntityId(), idpSsoDescriptor);
            this.identityProviders.add(samlIdentityProvider);
            samlIdentityProvider.setWantSingleLogoutMessagesSigned(samlIdp.isWantSingleLogoutMessagesSigned());
            samlIdentityProvider.setSingleLogoutMessagesSigned(samlIdp.isSingleLogoutMessagesSigned());
        }
        boolean wantAuthnRequestsSigned = false;
        for (SamlIdentityProvider identityProvider : this.identityProviders) {
            if (identityProvider instanceof SamlIdentityProvider && identityProvider.isWantAuthnRequestsSigned()) {
                wantAuthnRequestsSigned = true;
            }
            if (!identityProvider.getEntityId().equals(samlConfig.getDefaultIdentityProvider())) continue;
            this.defaultIdentityProvider = identityProvider;
        }
        if (wantAuthnRequestsSigned && !samlConfig.isAuthnRequestsSigned()) {
            throw new RuntimeException("Configuration error: at least one identity provider wants the authentication requests signed, but the service provider doesn't sign authentication requests.");
        }
        String keyStoreUrl = samlConfig.getKeyStoreUrl();
        String keyStorePass = samlConfig.getKeyStorePass();
        String signingKeyAlias = samlConfig.getSigningKeyAlias();
        String signingKeyPass = samlConfig.getSigningKeyPass();
        if (signingKeyPass == null) {
            signingKeyPass = keyStorePass;
        }
        this.getSigningKeyPair(keyStoreUrl, keyStorePass, signingKeyAlias, signingKeyPass);
    }

    private void readSamlMetaInformation() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.picketlink.identity.federation.saml.v2.metadata");
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement o = (JAXBElement)unmarshaller.unmarshal(this.getClass().getResource(SAML_ENTITIES_FILE));
            EntitiesDescriptorType entitiesDescriptor = (EntitiesDescriptorType)o.getValue();
            this.readEntitiesDescriptor(entitiesDescriptor);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void readEntitiesDescriptor(EntitiesDescriptorType entitiesDescriptor) {
        for (Object object : entitiesDescriptor.getEntityDescriptorOrEntitiesDescriptor()) {
            if (object instanceof EntityDescriptorType) {
                EntityDescriptorType entityDescriptor = (EntityDescriptorType)object;
                String entityId = entityDescriptor.getEntityID();
                for (RoleDescriptorType roleDescriptor : entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor()) {
                    if (!(roleDescriptor instanceof IDPSSODescriptorType)) continue;
                    IDPSSODescriptorType IDPSSODescriptor = (IDPSSODescriptorType)roleDescriptor;
                    this.idpMetaInfo.put(entityId, IDPSSODescriptor);
                }
                continue;
            }
            EntitiesDescriptorType descriptor = (EntitiesDescriptorType)object;
            this.readEntitiesDescriptor(descriptor);
        }
    }

    private void getSigningKeyPair(String keyStoreUrl, String keyStorePass, String signingKeyAlias, String signingKeyPass) {
        String classPathPrefix = "classpath:";
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            InputStream keyStoreStream = keyStoreUrl.startsWith("classpath:") ? this.getClass().getClassLoader().getResourceAsStream(keyStoreUrl.substring("classpath:".length())) : new URL(keyStoreUrl).openStream();
            char[] keyStorePwd = keyStorePass != null ? keyStorePass.toCharArray() : null;
            keyStore.load(keyStoreStream, keyStorePwd);
            this.certificate = (X509Certificate)keyStore.getCertificate(signingKeyAlias);
            char[] signingKeyPwd = signingKeyPass != null ? signingKeyPass.toCharArray() : null;
            this.privateKey = (PrivateKey)keyStore.getKey(signingKeyAlias, signingKeyPwd);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public SamlIdentityProvider getDefaultIdentityProvider() {
        return this.defaultIdentityProvider;
    }

    public List<SamlIdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public SamlIdentityProvider getSamlIdentityProviderByEntityId(String entityId) {
        for (SamlIdentityProvider identityProvider : this.identityProviders) {
            SamlIdentityProvider samlIdentityProvider;
            if (!(identityProvider instanceof SamlIdentityProvider) || !(samlIdentityProvider = identityProvider).getEntityId().equals(entityId)) continue;
            return samlIdentityProvider;
        }
        return null;
    }
}

