/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.seam.federation.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.List;
import org.jboss.seam.core.Expressions;
import org.picketlink.identity.seam.federation.ExternalAuthenticationService;
import org.picketlink.identity.seam.federation.configuration.Configuration;
import org.picketlink.identity.seam.federation.configuration.OpenIdConfiguration;
import org.picketlink.identity.seam.federation.configuration.SamlConfiguration;
import org.picketlink.identity.seam.federation.jaxb.config.ServiceProviderType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProvider {
    private Configuration configuration;
    private SamlConfiguration samlConfiguration;
    private OpenIdConfiguration openIdConfiguration;
    private String hostname;
    private String protocol;
    private int port;
    private String loggedOutUrl;
    private String unsolicitedAuthenticationUrl;
    private String failedAuthenticationUrl;
    private Expressions.MethodExpression<Boolean> internalAuthenticationMethod;

    public ServiceProvider(Configuration configuration, ServiceProviderType serviceProvider) {
        this.configuration = configuration;
        this.hostname = serviceProvider.getHostname();
        this.protocol = serviceProvider.getProtocol().value();
        this.loggedOutUrl = serviceProvider.getLoggedOutUrl();
        this.unsolicitedAuthenticationUrl = serviceProvider.getUnsolicitedAuthenticationUrl();
        this.failedAuthenticationUrl = serviceProvider.getFailedAuthenticationUrl();
        this.internalAuthenticationMethod = Expressions.instance().createMethodExpression(serviceProvider.getInternalAuthenticationMethod(), Boolean.class, new Class[]{Principal.class, List.class});
        this.port = serviceProvider.getPort() == null ? (this.protocol.equals("http") ? 8080 : 8443) : serviceProvider.getPort().intValue();
        if (serviceProvider.getSamlConfig() != null) {
            this.samlConfiguration = new SamlConfiguration(serviceProvider.getSamlConfig());
        }
        if (serviceProvider.getOpenIdConfig() != null) {
            this.openIdConfiguration = new OpenIdConfiguration(serviceProvider.getOpenIdConfig());
        }
    }

    public String getServiceURL(ExternalAuthenticationService service) {
        String path = this.configuration.getContextRoot() + "/" + service.getName() + ".seam";
        return this.createURL(path);
    }

    public String getOpenIdRealm() {
        return this.createURL("");
    }

    private String createURL(String path) {
        try {
            if (this.protocol.equals("http") && this.port == 80 || this.protocol.equals("https") && this.port == 443) {
                return new URL(this.protocol, this.hostname, path).toExternalForm();
            }
            return new URL(this.protocol, this.hostname, this.port, path).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SamlConfiguration getSamlConfiguration() {
        return this.samlConfiguration;
    }

    public OpenIdConfiguration getOpenIdConfiguration() {
        return this.openIdConfiguration;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getLoggedOutUrl() {
        return this.loggedOutUrl;
    }

    public String getUnsolicitedAuthenticationUrl() {
        return this.unsolicitedAuthenticationUrl;
    }

    public String getFailedAuthenticationUrl() {
        return this.failedAuthenticationUrl;
    }

    public Expressions.MethodExpression<Boolean> getInternalAuthenticationMethod() {
        return this.internalAuthenticationMethod;
    }
}

