/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.oauth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.picketlink.social.standalone.oauth.SecurityActions;

public class StringUtil {
    public static boolean isNotNull(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getSystemPropertyAsString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str");
        }
        if (str.contains("${")) {
            Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
            Matcher matcher = pattern.matcher(str);
            StringBuffer buffer = new StringBuffer();
            String sysPropertyValue = null;
            while (matcher.find()) {
                String subString = matcher.group(1);
                String defaultValue = "";
                if (subString.contains("::")) {
                    int index = subString.indexOf("::");
                    defaultValue = subString.substring(index + 2);
                    subString = subString.substring(0, index);
                }
                if ((sysPropertyValue = SecurityActions.getSystemProperty(subString, defaultValue)).isEmpty()) {
                    throw new RuntimeException(matcher.group(1));
                }
                matcher.appendReplacement(buffer, sysPropertyValue);
            }
            matcher.appendTail(buffer);
            str = buffer.toString();
        }
        return str;
    }

    public static void match(String first, String second) {
        if (!first.equals(second)) {
            throw new RuntimeException("Mismatch:" + first + " and " + second);
        }
    }

    public static List<String> tokenize(String str) {
        return StringUtil.tokenize(str, ",");
    }

    public static List<String> tokenize(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiter);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static Map<String, String> tokenizeKeyValuePair(String keyValuePairString) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> tokens = StringUtil.tokenize(keyValuePairString);
        for (String token : tokens) {
            int location = token.indexOf(61);
            map.put(token.substring(0, location), token.substring(location + 1));
        }
        return map;
    }
}

