/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GoogleAccessTokenContext
implements Serializable {
    private static final long serialVersionUID = -7038197192745766989L;
    private final GoogleTokenResponse tokenData;
    private final Set<String> scopes = new HashSet<String>();

    public GoogleAccessTokenContext(GoogleTokenResponse tokenData, String scopeAsString) {
        if (tokenData == null) {
            throw new IllegalArgumentException("tokenData can't be null");
        }
        if (scopeAsString == null) {
            throw new IllegalArgumentException("scope can't be null");
        }
        this.tokenData = tokenData;
        if (scopeAsString.length() > 0) {
            String[] scopes;
            for (String scope : scopes = scopeAsString.split(" ")) {
                this.scopes.add(scope);
            }
        }
    }

    public GoogleTokenResponse getTokenData() {
        return this.tokenData;
    }

    public String getScopesAsString() {
        StringBuilder result;
        Iterator<String> iterator = this.scopes.iterator();
        if (iterator.hasNext()) {
            result = new StringBuilder(iterator.next());
        } else {
            return "";
        }
        while (iterator.hasNext()) {
            result.append(" " + iterator.next());
        }
        return result.toString();
    }

    public boolean addScope(String scope) {
        return this.scopes.add(scope);
    }

    public boolean isScopeAvailable(String scope) {
        return this.scopes.contains(scope);
    }

    public String toString() {
        return "GoogleAccessTokenContext [tokenData=" + this.tokenData + ", scope=" + this.getScopesAsString() + "]";
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!that.getClass().equals(this.getClass())) {
            return false;
        }
        GoogleAccessTokenContext thatt = (GoogleAccessTokenContext)that;
        return this.scopes.equals(thatt.scopes) && this.tokenData.equals((Object)thatt.tokenData);
    }

    public int hashCode() {
        return this.scopes.hashCode() * 13 + this.tokenData.hashCode();
    }
}

