/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.standalone.google;

import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GoogleRefreshTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Tokeninfo;
import com.google.api.services.oauth2.model.Userinfo;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.picketlink.social.standalone.google.GoogleAccessTokenContext;
import org.picketlink.social.standalone.google.GoogleRequest;
import org.picketlink.social.standalone.google.InteractionState;
import org.picketlink.social.standalone.oauth.SocialException;
import org.picketlink.social.standalone.oauth.SocialExceptionCode;

public class GoogleProcessor {
    protected static Logger log = Logger.getLogger(GoogleProcessor.class);
    private final String returnURL;
    private final String clientID;
    private final String clientSecret;
    private final Set<String> scopes = new HashSet<String>();
    private final String accessType;
    private final String applicationName;
    private final HttpTransport TRANSPORT = new NetHttpTransport();
    private final JacksonFactory JSON_FACTORY = new JacksonFactory();
    private final SecureRandom secureRandom;

    public GoogleProcessor(String clientID, String clientSecret, String returnURL, String accessType, String applicationName, String randomAlgorithm, String scope) {
        this.checkNotNullParam("clientID", clientID);
        this.checkNotNullParam("clientSecret", clientSecret);
        this.checkNotNullParam("returnURL", returnURL);
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.returnURL = returnURL;
        this.accessType = accessType != null ? accessType : "offline";
        String string = this.applicationName = applicationName != null ? applicationName : "someApp";
        if (randomAlgorithm == null) {
            randomAlgorithm = "SHA1PRNG";
        }
        try {
            this.secureRandom = SecureRandom.getInstance(randomAlgorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalArgumentException("Can't create secureRandom", nsae);
        }
        if (scope == null) {
            scope = "https://www.googleapis.com/auth/userinfo.email https://www.googleapis.com/auth/userinfo.profile";
        }
        this.addScopesFromString(scope, this.scopes);
        if (log.isTraceEnabled()) {
            log.trace((Object)("configuration: clientId=" + clientID + ", clientSecret=" + clientSecret + ", returnURL=" + returnURL + ", scope=" + this.scopes + ", accessType=" + accessType + ", applicationName=" + applicationName + ", randomAlgorithm=" + randomAlgorithm));
        }
    }

    public InteractionState processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, SocialException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, this.scopes);
    }

    protected InteractionState processOAuthInteractionImpl(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException, SocialException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("_authState");
        if (state == null || state.isEmpty()) {
            return this.initialInteraction(request, response, scopes);
        }
        if (state.equals(InteractionState.State.AUTH.name())) {
            GoogleTokenResponse tokenResponse = this.obtainAccessToken(request);
            GoogleAccessTokenContext accessTokenContext = this.validateTokenAndUpdateScopes(new GoogleAccessTokenContext(tokenResponse, ""));
            session.removeAttribute("_authState");
            session.removeAttribute("_verificationState");
            return new InteractionState(InteractionState.State.FINISH, accessTokenContext);
        }
        return new InteractionState(InteractionState.State.valueOf(state), null);
    }

    protected InteractionState initialInteraction(HttpServletRequest request, HttpServletResponse response, Set<String> scopes) throws IOException {
        String verificationState = this.generateSecureString();
        String authorizeUrl = new GoogleAuthorizationCodeRequestUrl(this.clientID, this.returnURL, scopes).setState(verificationState).setAccessType(this.accessType).build();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting OAuth2 interaction with Google+");
            log.trace((Object)("URL to send to Google+: " + authorizeUrl));
        }
        HttpSession session = request.getSession();
        session.setAttribute("_verificationState", (Object)verificationState);
        session.setAttribute("_authState", (Object)InteractionState.State.AUTH.name());
        response.sendRedirect(authorizeUrl);
        return new InteractionState(InteractionState.State.AUTH, null);
    }

    protected GoogleTokenResponse obtainAccessToken(HttpServletRequest request) throws SocialException {
        GoogleTokenResponse tokenResponse;
        HttpSession session = request.getSession();
        String stateFromSession = (String)session.getAttribute("_verificationState");
        String stateFromRequest = request.getParameter("state");
        if (stateFromSession == null || stateFromRequest == null || !stateFromSession.equals(stateFromRequest)) {
            throw new SocialException(SocialExceptionCode.INVALID_STATE, "Validation of state parameter failed. stateFromSession=" + stateFromSession + ", stateFromRequest=" + stateFromRequest);
        }
        String error = request.getParameter("error");
        if (error != null) {
            if ("access_denied".equals(error)) {
                throw new SocialException(SocialExceptionCode.USER_DENIED_SCOPE, error);
            }
            throw new SocialException(SocialExceptionCode.UNKNOWN_ERROR, error);
        }
        String code = request.getParameter("code");
        try {
            tokenResponse = new GoogleAuthorizationCodeTokenRequest(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, this.clientID, this.clientSecret, code, this.returnURL).execute();
        }
        catch (IOException ioe) {
            throw new SocialException(SocialExceptionCode.INVALID_CLIENT, "Error when obtaining access token from Google: " + ioe.getMessage(), ioe);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained accessToken from google: " + tokenResponse));
        }
        return tokenResponse;
    }

    public GoogleAccessTokenContext validateTokenAndUpdateScopes(GoogleAccessTokenContext accessTokenContext) throws SocialException {
        GoogleRequest<Tokeninfo> googleRequest = new GoogleRequest<Tokeninfo>(){

            @Override
            protected Tokeninfo invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
                Oauth2 oauth2 = GoogleProcessor.this.getOAuth2Instance(accessTokenContext);
                GoogleCredential credential = GoogleProcessor.this.getGoogleCredential(tokenData);
                return (Tokeninfo)oauth2.tokeninfo().setAccessToken(credential.getAccessToken()).execute();
            }

            @Override
            protected SocialException createException(IOException cause) {
                if (cause instanceof HttpResponseException) {
                    return new SocialException(SocialExceptionCode.ACCESS_TOKEN_ERROR, "Error when obtaining tokenInfo: " + cause.getMessage(), cause);
                }
                return new SocialException(SocialExceptionCode.IO_ERROR, "IO Error when obtaining tokenInfo: " + cause.getMessage(), cause);
            }
        };
        Tokeninfo tokenInfo = (Tokeninfo)googleRequest.executeRequest(accessTokenContext, this);
        if (tokenInfo.containsKey((Object)"error")) {
            throw new SocialException(SocialExceptionCode.ACCESS_TOKEN_ERROR, "Error during token validation: " + tokenInfo.get((Object)"error").toString());
        }
        if (!tokenInfo.getIssuedTo().equals(this.clientID)) {
            throw new SocialException(SocialExceptionCode.ACCESS_TOKEN_ERROR, "Token's client ID does not match app's. clientID from tokenINFO: " + tokenInfo.getIssuedTo());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully validated accessToken from google: " + tokenInfo));
        }
        return new GoogleAccessTokenContext(accessTokenContext.getTokenData(), tokenInfo.getScope());
    }

    public Userinfo obtainUserInfo(GoogleAccessTokenContext accessTokenContext) throws SocialException {
        final Oauth2 oauth2 = this.getOAuth2Instance(accessTokenContext);
        GoogleRequest<Userinfo> googleRequest = new GoogleRequest<Userinfo>(){

            @Override
            protected Userinfo invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                return (Userinfo)oauth2.userinfo().v2().me().get().execute();
            }

            @Override
            protected SocialException createException(IOException cause) {
                if (cause instanceof HttpResponseException) {
                    return new SocialException(SocialExceptionCode.ACCESS_TOKEN_ERROR, "Error when obtaining userInfo: " + cause.getMessage(), cause);
                }
                return new SocialException(SocialExceptionCode.IO_ERROR, "IO Error when obtaining userInfo: " + cause.getMessage(), cause);
            }
        };
        Userinfo uinfo = (Userinfo)googleRequest.executeRequest(accessTokenContext, this);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained userInfo from google: " + uinfo));
        }
        return uinfo;
    }

    public Oauth2 getOAuth2Instance(GoogleAccessTokenContext accessTokenContext) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        GoogleCredential credential = this.getGoogleCredential(tokenData);
        return new Oauth2.Builder(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(this.applicationName).build();
    }

    private GoogleCredential getGoogleCredential(GoogleTokenResponse tokenResponse) {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.JSON_FACTORY).setTransport(this.TRANSPORT).setClientSecrets(this.clientID, this.clientSecret).build().setFromTokenResponse((TokenResponse)tokenResponse);
    }

    public void revokeToken(GoogleAccessTokenContext accessTokenContext) throws SocialException {
        GoogleRequest<Void> googleRequest = new GoogleRequest<Void>(){

            @Override
            protected Void invokeRequest(GoogleAccessTokenContext accessTokenContext) throws IOException {
                GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
                GoogleProcessor.this.TRANSPORT.createRequestFactory().buildGetRequest(new GenericUrl("https://accounts.google.com/o/oauth2/revoke?token=" + tokenData.getAccessToken())).execute();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Revoked token " + tokenData));
                }
                return null;
            }

            @Override
            protected SocialException createException(IOException cause) {
                return new SocialException(SocialExceptionCode.TOKEN_REVOCATION_FAILED, "Error when revoking token", cause);
            }
        };
        googleRequest.executeRequest(accessTokenContext, this);
    }

    public void refreshToken(GoogleAccessTokenContext accessTokenContext) {
        GoogleTokenResponse tokenData = accessTokenContext.getTokenData();
        if (tokenData.getRefreshToken() == null) {
            throw new SocialException(SocialExceptionCode.GOOGLE_ERROR, "Given GoogleTokenResponse does not contain refreshToken");
        }
        try {
            GoogleRefreshTokenRequest refreshTokenRequest = new GoogleRefreshTokenRequest(this.TRANSPORT, (JsonFactory)this.JSON_FACTORY, tokenData.getRefreshToken(), this.clientID, this.clientSecret);
            GoogleTokenResponse refreshed = refreshTokenRequest.execute();
            tokenData.setAccessToken(refreshed.getAccessToken());
            if (log.isTraceEnabled()) {
                log.trace((Object)("AccessToken refreshed successfully with value " + refreshed.getAccessToken()));
            }
        }
        catch (IOException ioe) {
            throw new SocialException(SocialExceptionCode.GOOGLE_ERROR, ioe.getMessage(), ioe);
        }
    }

    private void addScopesFromString(String scope, Set<String> scopes) {
        String[] scopes2;
        for (String current : scopes2 = scope.split(" ")) {
            scopes.add(current);
        }
    }

    private void checkNotNullParam(String paramName, String paramValue) {
        if (paramValue == null) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' must be not null");
        }
    }

    protected String generateSecureString() {
        return String.valueOf(this.secureRandom.nextLong());
    }
}

