/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.jaas;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginException;
import javax.xml.ws.Binding;
import javax.xml.ws.Dispatch;
import javax.xml.ws.handler.Handler;
import org.jboss.logging.Logger;
import org.picketlink.identity.federation.bindings.jboss.subject.PicketLinkPrincipal;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.STSIssuingLoginModule;
import org.picketlink.trust.jbossws.PicketLinkDispatch;
import org.picketlink.trust.jbossws.handler.BinaryTokenHandler;
import org.picketlink.trust.jbossws.handler.SAML2Handler;
import org.picketlink.trust.jbossws.jaas.SecurityActions;

public class JBWSTokenIssuingLoginModule
extends STSIssuingLoginModule {
    public static final String WSA_ISSUER = "wsaIssuer";
    public static final String WSP_APPIESTO = "wspAppliesTo";

    protected STSClientConfig.Builder createBuilder() {
        STSClientConfig.Builder builder = super.createBuilder();
        builder.wsaIssuer((String)this.options.get(WSA_ISSUER));
        builder.wspAppliesTo((String)this.options.get(WSP_APPIESTO));
        return builder;
    }

    protected STSClient createWSTrustClient(STSClientConfig config) {
        return new JBWSTokenClient(config, this.options);
    }

    public boolean commit() throws LoginException {
        boolean result = super.commit();
        if (result) {
            SamlCredential samlCredential = null;
            Set<Object> creds = this.subject.getPublicCredentials();
            for (Object cred : creds) {
                if (!(cred instanceof SamlCredential)) continue;
                samlCredential = (SamlCredential)cred;
                break;
            }
            if (samlCredential == null) {
                throw new LoginException("PL00092: Null Value:SamlCredential is not available in subject");
            }
            PicketLinkPrincipal principal = new PicketLinkPrincipal("");
            if (super.isUseFirstPass()) {
                this.sharedState.put("javax.security.auth.login.name", principal);
                this.sharedState.put("javax.security.auth.login.password", samlCredential);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JBWSTokenClient
    extends STSClient {
        private Logger log;
        private boolean trace;

        public JBWSTokenClient() {
            this.log = Logger.getLogger(JBWSTokenClient.class);
            this.trace = this.log.isTraceEnabled();
        }

        public JBWSTokenClient(STSClientConfig config) {
            super(config);
            this.log = Logger.getLogger(JBWSTokenClient.class);
            this.trace = this.log.isTraceEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JBWSTokenClient(STSClientConfig config, Map<String, ?> options) {
            boolean bool;
            super(config);
            this.log = Logger.getLogger(JBWSTokenClient.class);
            this.trace = this.log.isTraceEnabled();
            Dispatch dispatch = super.getDispatch();
            String overrideDispatchStr = (String)options.get("overrideDispatch");
            if (StringUtil.isNotNull((String)overrideDispatchStr) && (bool = Boolean.valueOf(overrideDispatchStr).booleanValue())) {
                dispatch = new PicketLinkDispatch(dispatch, (String)options.get("endpointAddress"));
                String useWSSE = (String)options.get("useWSSE");
                if (StringUtil.isNotNull((String)useWSSE) && useWSSE.equalsIgnoreCase("true")) {
                    ((PicketLinkDispatch)dispatch).setUseWSSE(true);
                }
            }
            Binding binding = dispatch.getBinding();
            List handlers = binding.getHandlerChain();
            String handlerStr = (String)options.get("handlerChain");
            if (StringUtil.isNotNull((String)handlerStr)) {
                List tokens = StringUtil.tokenize((String)handlerStr);
                for (String token : tokens) {
                    if (token.equalsIgnoreCase("binary")) {
                        BinaryTokenHandler binaryTokenHandler = new BinaryTokenHandler();
                        handlers.add(binaryTokenHandler);
                        continue;
                    }
                    if (token.equalsIgnoreCase("saml2")) {
                        SAML2Handler samlHandler = new SAML2Handler();
                        handlers.add(samlHandler);
                        continue;
                    }
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    try {
                        handlers.add((Handler)cl.loadClass(token).newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("PL00086: Cannot create instance of:Unable to instantiate handler:" + token, e);
                    }
                }
            }
            binding.setHandlerChain(handlers);
            this.setDispatch(dispatch);
            String securityDomainForFactory = (String)options.get("securityDomainForFactory");
            if (StringUtil.isNotNull((String)securityDomainForFactory)) {
                if (this.trace) {
                    this.log.trace((Object)("We got security domain for domain ssl factory = " + securityDomainForFactory));
                    this.log.trace((Object)"Setting it on the system property org.jboss.security.ssl.domain.name");
                }
                String sslFactoryName = "org.jboss.security.ssl.JaasSecurityDomainSocketFactory";
                SecurityActions.setSystemProperty("org.jboss.security.ssl.domain.name", securityDomainForFactory);
                dispatch.getRequestContext().put("org.jboss.ws.socketFactory", sslFactoryName);
                if (dispatch instanceof PicketLinkDispatch) {
                    ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
                    SSLSocketFactory socketFactory = null;
                    if (cl != null) {
                        try {
                            Class<?> clazz = cl.loadClass(sslFactoryName);
                            socketFactory = (SSLSocketFactory)clazz.newInstance();
                        }
                        catch (Exception e) {
                            cl = SecurityActions.getContextClassLoader();
                            try {
                                Class<?> clazz = cl.loadClass(sslFactoryName);
                                socketFactory = (SSLSocketFactory)clazz.newInstance();
                            }
                            catch (Exception e1) {
                                throw new RuntimeException("PL00102: Processing Exception:Unable to create SSL Socket Factory:", e1);
                            }
                        }
                        finally {
                            if (socketFactory == null) {
                                throw new RuntimeException(" We did not find SSL Socket Factory");
                            }
                            ((PicketLinkDispatch)dispatch).setSSLSocketFactory(socketFactory);
                        }
                    } else if (this.trace) {
                        this.log.trace((Object)"Classloader is null. Unable to set the SSLSocketFactory on PicketLinkDispatch");
                    }
                }
            }
        }
    }
}

