/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.trust.jbossws.handler;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import javax.security.auth.Subject;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.security.SecurityContext;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.trust.jbossws.handler.AbstractSAML2Handler;

public class SAML2Handler
extends AbstractSAML2Handler {
    protected void createSecurityContext(SamlCredential credential, Subject theSubject, Principal principal, MessageContext msgContext) {
        super.createSecurityContext(credential, theSubject, principal, msgContext);
        SecurityContext secContext = this.createCXFSecurityContext(theSubject, principal);
        if (PhaseInterceptorChain.getCurrentMessage() != null) {
            PhaseInterceptorChain.getCurrentMessage().put(SecurityContext.class, (Object)secContext);
        }
    }

    private SecurityContext createCXFSecurityContext(final Subject theSubject, final Principal principal) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                if (theSubject == null || theSubject.getPrincipals().size() <= 1) {
                    return false;
                }
                for (Principal principal2 : theSubject.getPrincipals()) {
                    if (!(principal2 instanceof Group) || !SAML2Handler.this.checkGroup((Group)principal2, role)) continue;
                    return true;
                }
                return false;
            }

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    protected boolean checkGroup(Group group, String role) {
        if (group.getName().equals(role)) {
            return true;
        }
        Enumeration members = group.members();
        while (members.hasMoreElements()) {
            Principal member = (Principal)members.nextElement();
            if (!member.getName().equals(role) && (!(member instanceof Group) || !this.checkGroup((Group)member, role))) continue;
            return true;
        }
        return false;
    }
}

