/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * Http handler which uses {@see SPFormAuthenticationRequestWrapper} for wrapping request if need to be.
 * Needed for fix of JBEAP-10449.
 */
class SPFormAuthenticationRequestHandler implements HttpHandler {


    public static final HandlerWrapper wrapper() {
        return (next) -> new SPFormAuthenticationRequestHandler(next);
    }

    private final HttpHandler next;

    public SPFormAuthenticationRequestHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {

        //wrap request, if wrap is applied
        ServletRequestContext servletRequestContext = exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest originalRequest = servletRequestContext.getServletRequest();
        HttpServletRequest request = SPFormAuthrenticationRequestUtil.wrapRequest(exchange);
        if(!originalRequest.equals(request)) {
            servletRequestContext.setServletRequest(request);
        }
        //continue with other handkers
        next.handleRequest(exchange);
    }
}
